/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.bizopt;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.centit.dde.config.RedisConfig;
import com.centit.dde.config.RedisTypeEnum;
import com.centit.dde.core.BizModel;
import com.centit.dde.core.BizOperation;
import com.centit.dde.core.DataOptContext;
import com.centit.dde.core.DataSet;
import com.centit.dde.entity.RedisParamVo;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseSingleData;
import com.centit.product.adapter.po.SourceInfo;
import com.centit.product.metadata.dao.SourceInfoDao;
import java.lang.reflect.Method;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisBizOperation
implements BizOperation {
    private SourceInfoDao sourceInfoDao;

    public RedisBizOperation(SourceInfoDao sourceInfoDao) {
        this.sourceInfoDao = sourceInfoDao;
    }

    public ResponseData runOpt(BizModel bizModel, JSONObject bizOptJson, DataOptContext dataOptContext) throws Exception {
        Method[] declaredMethods;
        RedisParamVo redisParamVo = (RedisParamVo)JSON.parseObject((String)bizOptJson.toJSONString(new JSONWriter.Feature[0]), RedisParamVo.class);
        SourceInfo sourceInfo = this.sourceInfoDao.getDatabaseInfoById("dataSourceId");
        RedisConfig redisConfig = new RedisConfig();
        String redisType = redisParamVo.getRedisType();
        RedisTypeEnum redisTypeEnum = redisType.equals("singleNode") ? RedisTypeEnum.SINGLENODE : (redisType.equals("cluster") ? RedisTypeEnum.CLUSTER : (redisType.equals("sentinel") ? RedisTypeEnum.SENTINEL : RedisTypeEnum.SINGLENODE));
        RedisTemplate<String, Object> redisTemplate = redisConfig.redisTemplate(sourceInfo, redisTypeEnum);
        Class<?> aClass = Class.forName("com.centit.dde.utils.RedisOperationUtils");
        Class<?>[] parameterTypes = null;
        for (Method declaredMethod : declaredMethods = aClass.getDeclaredMethods()) {
            if (!declaredMethod.getName().equals(redisParamVo.getMethodName())) continue;
            parameterTypes = declaredMethod.getParameterTypes();
        }
        Method setRedisTemplate = aClass.getMethod("setRedisTemplate", RedisTemplate.class);
        Object instance = aClass.newInstance();
        setRedisTemplate.invoke(instance, redisTemplate);
        Method method = aClass.getMethod(redisParamVo.getMethodName(), parameterTypes);
        Object invoke = method.invoke(instance, (Object[])redisParamVo.getMethodParam());
        bizModel.putDataSet(redisParamVo.getId(), new DataSet(invoke));
        return ResponseSingleData.makeResponseData((Object)bizModel.getDataSet(redisParamVo.getId()).getSize());
    }
}

