/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.bizopt;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import com.alibaba.fastjson.JSONObject;
import com.centit.dde.core.BizModel;
import com.centit.dde.core.BizOperation;
import com.centit.dde.core.DataSet;
import com.centit.dde.core.SimpleDataSet;
import com.centit.dde.vo.OFDPreviewVo;
import com.centit.framework.common.ResponseData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class OFDPreviewBizOperation
implements BizOperation {
    public static final Log log = LogFactory.getLog(OFDPreviewBizOperation.class);

    public ResponseData runOpt(BizModel bizModel, JSONObject bizOptJson) {
        OFDPreviewVo ofdPreviewVo = (OFDPreviewVo)bizOptJson.toJavaObject(OFDPreviewVo.class);
        String httpUrl = ofdPreviewVo.getHttpUrl();
        if (StringUtils.isBlank((CharSequence)httpUrl)) {
            return ResponseData.makeErrorMessage((String)"\u670d\u52a1\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u670d\u52a1\u5730\u5740\uff01");
        }
        DataSet dataSet = bizModel.getDataSet(ofdPreviewVo.getSource());
        Object data = dataSet.getData();
        if (data instanceof OutputStream) {
            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)data;
            JSONObject jsonObject = OFDPreviewBizOperation.httpPostRequest(httpUrl, byteArrayOutputStream, ofdPreviewVo.getSource() + ".ofd");
            if (jsonObject == null) {
                return ResponseData.makeErrorMessage((String)"\u8bf7\u6c42\u9884\u89c8\u670d\u52a1\u5f02\u5e38\uff01");
            }
            httpUrl = httpUrl.endsWith("/") ? httpUrl : httpUrl + File.separator;
            String previewUrl = httpUrl + "reader?file=" + jsonObject.getString("name");
            bizModel.putDataSet(ofdPreviewVo.getId(), (DataSet)new SimpleDataSet((Object)previewUrl));
            return ResponseData.makeSuccessResponse((String)"ok");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject httpPostRequest(String urlParam, ByteArrayOutputStream byteArrayOutputStream, String fileName) {
        if (StringUtils.isNotBlank((CharSequence)urlParam)) {
            urlParam = StringUtils.isNotBlank((CharSequence)urlParam) ? urlParam + "reader?&type=upload" : urlParam + File.separator + "reader?&type=upload";
        }
        TimeInterval timer = DateUtil.timer();
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost uploadFile = new HttpPost(urlParam);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        ByteArrayInputStream input = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        builder.addBinaryBody("file", (InputStream)input, ContentType.APPLICATION_OCTET_STREAM, fileName);
        HttpEntity multipart = builder.build();
        uploadFile.setEntity(multipart);
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)uploadFile);
            HttpEntity responseEntity = response.getEntity();
            String sResponse = EntityUtils.toString((HttpEntity)responseEntity, (String)"UTF-8");
            log.info((Object)("\u8bf7\u6c42OFD\u9884\u89c8\u670d\u52a1,\u8bf7\u6c42\u5730\u5740\uff1a" + urlParam + "\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a" + sResponse + "\u8bf7\u6c42\u8017\u65f6\uff1a" + timer.interval()));
            JSONObject jSONObject = JSONObject.parseObject((String)sResponse);
            return jSONObject;
        }
        catch (IOException e) {
            log.error((Object)("\u8bf7\u6c42OFD\u9884\u89c8\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage()));
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        return null;
    }
}

