/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.bizopt;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import com.alibaba.fastjson.JSONObject;
import com.centit.dde.core.BizModel;
import com.centit.dde.core.BizOperation;
import com.centit.dde.core.DataSet;
import com.centit.dde.core.SimpleDataSet;
import com.centit.dde.vo.OFDConvertVo;
import com.centit.fileserver.client.FileClientImpl;
import com.centit.fileserver.client.po.FileInfo;
import com.centit.fileserver.common.FileStore;
import com.centit.framework.common.ResponseData;
import com.suwell.ofd.custom.agent.HTTPAgent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OFDConvertBizOperation
implements BizOperation {
    public static final Log log = LogFactory.getLog(OFDConvertBizOperation.class);
    private FileClientImpl fileClient;
    private FileStore fileStore;

    public OFDConvertBizOperation(FileClientImpl fileClient, FileStore fileStore) {
        this.fileClient = fileClient;
        this.fileStore = fileStore;
    }

    public OFDConvertBizOperation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseData runOpt(BizModel bizModel, JSONObject bizOptJson) throws Exception {
        OFDConvertVo ofdConvertVo = (OFDConvertVo)bizOptJson.toJavaObject(OFDConvertVo.class);
        String fileids = ofdConvertVo.getFileid();
        if (StringUtils.isBlank((CharSequence)fileids)) {
            return ResponseData.makeErrorMessage((String)"\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String[] fileidArr = fileids.split(",");
        ArrayList<File> fileList = new ArrayList<File>();
        for (String fileId : fileidArr) {
            FileInfo fileInfo = this.fileClient.getFileInfo(fileId);
            String fileName = fileInfo.getFileName();
            File file = this.fileStore.getFile(fileInfo.getFileId());
            String path = file.getParent();
            boolean b = file.renameTo(new File(path + File.separator + fileName));
            fileList.add(new File(path + File.separator + fileName));
        }
        TimeInterval timer = DateUtil.timer();
        HTTPAgent httpAgent = null;
        ByteArrayOutputStream stream = null;
        try {
            httpAgent = new HTTPAgent(ofdConvertVo.getHttpUrl());
            stream = new ByteArrayOutputStream();
            httpAgent.officesToOFD(fileList, (OutputStream)stream);
            bizModel.putDataSet(ofdConvertVo.getId(), (DataSet)new SimpleDataSet((Object)stream));
            log.info((Object)("\u8bf7\u6c42\u8f6c\u6362\u6587\u4ef6\u670d\u52a1,\u8bf7\u6c42\u670d\u52a1\u5730\u5740\uff1a" + ofdConvertVo.getHttpUrl() + "\uff0c\u8bf7\u6c42\u8017\u65f6\uff1a" + timer.interval() + "ms"));
        }
        catch (Exception e) {
            log.error((Object)("\u8bf7\u6c42\u8f6c\u6362\u6587\u4ef6\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage()));
        }
        finally {
            try {
                if (httpAgent != null) {
                    httpAgent.close();
                }
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        return ResponseData.successResponse;
    }
}

