package com.centit.dde.controller;

import com.alibaba.fastjson2.JSON;
import com.centit.dde.adapter.po.DataPacket;
import com.centit.dde.adapter.po.DataPacketInterface;
import com.centit.dde.core.DataOptContext;
import com.centit.dde.core.DataOptResult;
import com.centit.dde.services.BizModelService;
import com.centit.dde.services.DataPacketDraftService;
import com.centit.dde.services.DataPacketService;
import com.centit.dde.utils.ConstantValue;
import com.centit.fileserver.utils.UploadDownloadUtils;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.OsInfo;
import com.centit.framework.model.security.CentitUserDetails;
import com.centit.framework.security.CentitSecurityMetadata;
import com.centit.framework.security.SecurityContextUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.file.FileIOOpt;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.InvalidFileNameException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.commons.CommonsMultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author codefan@sina.com
 */
public abstract class DoApiController extends BaseController {

    @Autowired
    protected PlatformEnvironment platformEnvironment;

    @Autowired
    protected DataPacketService dataPacketService;

    @Autowired
    protected DataPacketDraftService dataPacketDraftService;

    @Autowired
    protected BizModelService bizmodelService;

    protected Map<String, DataPacket> dataPacketCachedMap = new ConcurrentHashMap<>(10000);

    private void judgePower(String packetId, CentitUserDetails ud, HttpServletRequest request){
        List<ConfigAttribute> needRoles = CentitSecurityMetadata.getApiRoleList(packetId);
        if (needRoles==null || needRoles.isEmpty() ){ // 没有配置角色，后面如果严格就抛无权限
            if(ud != null)  return; // 没有配置角色，对于已登录用户放行
        } else if(needRoles.contains(new SecurityConfig(SecurityContextUtils.SPRING_ANONYMOUS_ROLE_CODE))){ //匿名用户放行
            return;
        }
        if(ud == null){ // 抛未登录异常
            throw new ObjectException(ResponseData.ERROR_USER_NOT_LOGIN,
                getI18nMessage(ResponseData.ERROR_NOT_LOGIN_MSG, request) );
        }
        Collection<? extends GrantedAuthority> userRoles = ud.getAuthorities();
        if(userRoles!=null){
            Iterator<? extends GrantedAuthority> userRolesItr = userRoles.iterator();
            Iterator<ConfigAttribute> needRolesItr = needRoles.iterator();
            String needRole = needRolesItr.next().getAttribute();
            String userRole = userRolesItr.next().getAuthority();
            while(true){
                int n = needRole.compareTo(userRole);
                if(n==0)
                    return; // 匹配成功 完成认证
                if(n<0){
                    if(!needRolesItr.hasNext())
                        break;
                    needRole = needRolesItr.next().getAttribute();
                }else{
                    if(!userRolesItr.hasNext())
                        break;
                    userRole = userRolesItr.next().getAuthority();
                }
            }
        }
        String packName;
        DataPacket dataPacket = dataPacketService.getDataPacket(packetId);
        if(dataPacket!=null){
            packName = dataPacket.getPacketName() + "(" + dataPacket.getOptId() + ")";
        }else{
            packName = packetId;
        }
        StringBuilder errorMsgBuilder = new StringBuilder("  用户没有权限: ").append(packName).append(";\r\n需要角色: ");
        boolean firstRole = true;
        for(ConfigAttribute ca : needRoles){
            if(firstRole){
                firstRole = false;
            } else {
                errorMsgBuilder.append(", ");
            }
            String roleCode = ca.getAttribute().substring(2);
            errorMsgBuilder.append(CodeRepositoryUtil.getValue(CodeRepositoryUtil.ROLE_CODE, roleCode,
                WebOptUtils.getCurrentTopUnit(request), WebOptUtils.getCurrentLang(request), roleCode));
        }
        errorMsgBuilder.append(".");
        throw new ObjectException(ResponseData.HTTP_FORBIDDEN, errorMsgBuilder.toString());
    }

    /*
    private void judgeDebugPower(@PathVariable String packetId, String runType, HttpServletRequest request) {
        if (ConstantValue.RUN_TYPE_DEBUG.equals(runType)) {
            String loginUser = WebOptUtils.getCurrentUserCode(request);
            if (StringUtils.isBlank(loginUser)) {
                throw new ObjectException(ResponseData.ERROR_USER_NOT_LOGIN,
                    getI18nMessage( "error.302.user_not_login", request));
            }
            DataPacketInterface dataPacket = dataPacketDraftService.getDataPacket(packetId);
            List<WorkGroup> userGroups = platformEnvironment.listWorkGroup(dataPacket.getOsId(), loginUser, null);
            if(CollectionUtils.isEmpty(userGroups)){
                throw new ObjectException(ResponseData.HTTP_NON_AUTHORITATIVE_INFORMATION,
                    getI18nMessage( "error.403.access_forbidden", request));
            }
        }
    }*/

    protected void returnObject(String packetId, String runType, String taskType, List<String> urlParams,
                                HttpServletRequest request, HttpServletResponse response) throws IOException {
        CentitUserDetails userDetails = WebOptUtils.getCurrentUserDetails(request);
        judgePower(packetId, userDetails, request);
        // 获取接口信息
        DataPacketInterface dataPacketInterface;
        if(ConstantValue.RUN_TYPE_DEBUG.equals(runType)){
            dataPacketInterface = dataPacketDraftService.getDataPacket(packetId);
        } else {
            DataPacket dataPacket = dataPacketService.getDataPacket(packetId);
            if(dataPacket==null){
                dataPacketCachedMap.remove(packetId);
                dataPacketInterface = null;
            } else {
                DataPacket cachedPacket = dataPacketCachedMap.get(packetId);
                if (cachedPacket == null || DatetimeOpt.compareTwoDate(dataPacket.getPublishDate(), cachedPacket.getPublishDate()) != 0) {
                    dataPacketInterface = dataPacket;
                    dataPacketCachedMap.put(packetId, dataPacket);
                } else {
                    dataPacketInterface = cachedPacket;
                }
            }
        }

        if (dataPacketInterface == null) {
            throw new ObjectException(ObjectException.DATA_NOT_FOUND_EXCEPTION,
               getI18nMessage("dde.604.api_not_found", request, packetId));
        }
        if (ConstantValue.TASK_TYPE_MSG.equals(dataPacketInterface.getTaskType())) {
            throw new ObjectException(ResponseData.HTTP_METHOD_NOT_ALLOWED,
                getI18nMessage("dde.405.method_not_support", request, packetId));
        }
        if (!taskType.equals(dataPacketInterface.getTaskType()) &&
            !ConstantValue.TASK_TYPE_TIME.equals(dataPacketInterface.getTaskType())) {
            throw new ObjectException(ResponseData.HTTP_METHOD_NOT_ALLOWED,
                getI18nMessage("dde.405.request_type_not_match", request, packetId));
        }
        if (ConstantValue.RUN_TYPE_NORMAL.equals(runType)  && ! dataPacketInterface.canRunAsNormal()) {
            String errorPacket=packetId;
            if(dataPacketInterface.getIsDisable()){
                errorPacket="在回收站："+packetId+dataPacketInterface.getPacketName();
            }
            throw new ObjectException(ResponseData.HTTP_METHOD_NOT_ALLOWED,
                getI18nMessage("dde.405.api_is_disable", request, errorPacket));
        }
        //根据api默认值初始化， 并且准备执行上下文环境
        Map<String, Object> params = new HashMap<>(dataPacketInterface.getPacketParamsValue());
        params.putAll(collectRequestParameters(request));
        //保存内部逻辑变量，有些时候需要将某些值传递到其它标签节点，这时候需要用到它
        DataOptContext dataOptContext = new DataOptContext(this.messageSource, WebOptUtils.getCurrentLocale(request));
        dataOptContext.setRunType(runType);
        Object obj =  params.get("debugId");
        if(obj!=null) {
            dataOptContext.setDebugId(StringBaseOpt.castObjectToString(obj));
        }
        obj =  params.get("breakStepNo");
        if(obj!=null) {
            dataOptContext.setBreakStepNo(NumberBaseOpt.castObjectToInteger(obj, -1));
        }

        if (ConstantValue.TASK_TYPE_POST.equals(taskType) || ConstantValue.TASK_TYPE_PUT.equals(taskType) ||
            "POST".equalsIgnoreCase(request.getMethod()) || "PUT".equalsIgnoreCase(request.getMethod())) {
            String contentType = request.getHeader("Content-Type");
            if (StringBaseOpt.isNvl(contentType)) {
               contentType="application/json";
            }
            if (StringUtils.contains(contentType, "application/json")) {
                String bodyString = FileIOOpt.readStringFromInputStream(request.getInputStream(), String.valueOf(StandardCharsets.UTF_8));
                dataOptContext.setStackData(ConstantValue.REQUEST_BODY_TAG, JSON.parse(bodyString));
            } else if(StringUtils.contains(contentType, "application/x-www-form-urlencoded")){
                Map<String, Object> bodyMap = new HashMap<>(32);
                for(Map.Entry<String, String[]> ent : request.getParameterMap().entrySet()){
                    if(ent.getValue().length==1){
                        bodyMap.put(ent.getKey(), ent.getValue()[0]);
                    }else {
                        bodyMap.put(ent.getKey(), ent.getValue());
                    }
                }
                dataOptContext.setStackData(ConstantValue.REQUEST_BODY_TAG, bodyMap);
            } else if(StringUtils.contains(contentType, "application/octet-stream")){
                String filename = request.getHeader("filename");
                if (StringUtils.isBlank(filename)) {
                    filename = request.getHeader("fileName");
                    if (StringUtils.isBlank(filename)) {
                        filename = StringBaseOpt.castObjectToString(params.get("filename"));
                    }
                }
                String fileName2 = StringBaseOpt.castObjectToString(params.get("fileName"));
                if (StringUtils.isNotBlank(filename) && StringUtils.isBlank(fileName2)) {
                    params.put("fileName", filename);
                }
                if (StringUtils.isBlank(filename)) {
                    filename = fileName2;
                    if (StringUtils.isBlank(filename)) {
                        filename = "attachment.dat";
                    }
                }

                InputStream inputStream = UploadDownloadUtils.fetchInputStreamFromMultipartResolver(request).getRight();
                if (inputStream != null) {
                    dataOptContext.setStackData(ConstantValue.REQUEST_FILE_TAG,
                        CollectionsOpt.createHashMap(
                            "fileName", filename,
                            "fileSize", inputStream.available(),
                            "fileContent", inputStream));
                }
            } else if(StringUtils.contains(contentType, "text/plain")){
                String bodyString = FileIOOpt.readStringFromInputStream(request.getInputStream(),
                    String.valueOf(StandardCharsets.UTF_8));
                dataOptContext.setStackData(ConstantValue.REQUEST_BODY_TAG, bodyString);
            } else if(StringUtils.contains(contentType, "multipart/form-data")){
                MultipartResolver resolver = new CommonsMultipartResolver(request.getSession().getServletContext());
                MultipartHttpServletRequest multiRequest = resolver.resolveMultipart(request);
                Map<String, Object> bodyMap = new HashMap<>(32);
                Map<String, String[]> mParams =  multiRequest.getParameterMap();
                if(mParams!=null) {
                    for (Map.Entry<String, String[]> entry : mParams.entrySet()) {
                        if(entry.getValue()!=null) {
                            if (entry.getValue().length == 1) {
                                bodyMap.put(entry.getKey(), entry.getValue()[0]);
                            } else {
                                bodyMap.put(entry.getKey(), entry.getValue());
                            }
                        }
                    }
                }

                Map<String, MultipartFile> map = multiRequest.getFileMap();
                for (Map.Entry<String, MultipartFile> entry : map.entrySet()) {
                    CommonsMultipartFile cMultipartFile = (CommonsMultipartFile) entry.getValue();
                    FileItem fi = cMultipartFile.getFileItem();
                    String fieldName = fi.getFieldName();
                    String itemType = fi.getHeaders().getHeader("Content-Type");
                    if (!fi.isFormField() || itemType.contains("application/octet-stream")) {
                        String filename = null;
                        try{
                            filename = fi.getName();
                        } catch (InvalidFileNameException e){
                            logger.error(e.getMessage());
                        }
                        if (StringUtils.isBlank(filename)) {
                            filename = fi.getHeaders().getHeader("filename");
                            if (StringUtils.isBlank(filename)) {
                                filename = fi.getHeaders().getHeader("fileName");
                                if (StringUtils.isBlank(filename)) {
                                    filename = StringBaseOpt.castObjectToString(params.get("filename"));
                                    if (StringUtils.isBlank(filename)) {
                                        filename = StringBaseOpt.castObjectToString(params.get("fileName"));
                                        if (StringUtils.isBlank(filename)) {
                                            filename = "attachment.dat";
                                        }
                                    }
                                }
                            }
                        }
                        InputStream inputStream = fi.getInputStream();
                        if (inputStream != null) {
                            Map<String, Object> fileData = CollectionsOpt.createHashMap(
                                "fileName", filename,
                                "fileSize", inputStream.available(),
                                "fileContent", inputStream);
                            dataOptContext.setStackData(ConstantValue.REQUEST_FILE_TAG, fileData);
                            if(StringUtils.isNotBlank(fieldName)) {
                                Object object = bodyMap.get(fieldName);
                                if(object == null) {
                                    bodyMap.put(fieldName, fileData);
                                } else if(object instanceof Map){
                                    List<Object> fileList = new ArrayList<>();
                                    fileList.add(object);
                                    fileList.add(fileData);
                                    bodyMap.put(fieldName, fileList);
                                } else if(object instanceof List){
                                    ((List<Object>) object).add(fileData);
                                } else {
                                    bodyMap.put(fieldName, fileData);
                                }
                            }
                        }
                    } else if (itemType.contains("application/json")) {
                        String bodyString = fi.getString();
                        bodyMap.put(fieldName, JSON.parse(bodyString));
                    } else { //if (itemType.contains("text/plain")) {
                        String bodyString = fi.getString();
                        bodyMap.put(fieldName, bodyString);
                    }
                }
                dataOptContext.setStackData(ConstantValue.REQUEST_BODY_TAG, bodyMap);
            } else { //
                throw new ObjectException(ObjectException.FUNCTION_NOT_SUPPORT,
                    getI18nMessage("dde.613.form_type_not_support", request, contentType));
            }
        }

        params.put(SecurityContextUtils.SecurityContextTokenName, request.getSession().getId());
        dataOptContext.setStackData(ConstantValue.REQUEST_PARAMS_TAG, params);
        if(urlParams != null && !urlParams.isEmpty()) {
            dataOptContext.setStackData(ConstantValue.REQUEST_URL_PARAMS_TAG, urlParams);
        }

        Map<String, String> cookies = WebOptUtils.fetchRequestCookies(request);
        if(cookies!=null){
            dataOptContext.setStackData(ConstantValue.REQUEST_COOKIES_TAG, cookies);
        }

        Map<String, String> headers = WebOptUtils.fetchRequestHeaders(request);
        if(cookies!=null){
            dataOptContext.setStackData(ConstantValue.REQUEST_HEADERS_TAG, headers);
        }
        //request.getCookies().
        OsInfo osInfo = platformEnvironment.getOsInfo(dataPacketInterface.getOsId());
        dataOptContext.setStackData(ConstantValue.APPLICATION_INFO_TAG, osInfo);
        if(userDetails!=null) {
            dataOptContext.setStackData(ConstantValue.SESSION_DATA_TAG, userDetails);
            dataOptContext.setTopUnit(userDetails.getTopUnitCode());
        } // 准备运行环境完毕
        // 调用DDE数据执行引擎
        DataOptResult result = bizmodelService.runBizModel(dataPacketInterface, dataOptContext);
        // 返回
        if (result.getResultType() == DataOptResult.RETURN_FILE_STREAM) {
            InputStream in = result.getReturnFileStream();
            if (in != null /*&& fileName != null*/) {
                UploadDownloadUtils.downFileRange(request, response, in,
                    in.available(), result.getReturnFilename(), request.getParameter("downloadType"), null);
            } else {
                JsonResultUtils.writeOriginalObject(
                    ResponseData.makeErrorMessage(ObjectException.DATA_NOT_FOUND_EXCEPTION,
                        getI18nMessage("dde.604.return_file_not_found", request)), response);
            }
            return;
        }
        if (result.getResultType() == DataOptResult.RETURN_DATA_AS_RAW) {
            JsonResultUtils.writeOriginalObject(result.getResultObject(), response);
        } else {
            JsonResultUtils.writeOriginalObject(result.toResponseData(), response);
        }
    }

}
