/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.utils;

import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.support.common.ObjectException;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class LoginUserPermissionCheck {
    public static void loginUserPermissionCheck(BaseController controller, PlatformEnvironment platformEnvironment, String osId, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)osId)) {
            throw new ObjectException(701, controller.getI18nMessage("error.701.field_is_blank", request, new Object[]{osId}));
        }
        String loginUser = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)loginUser)) {
            loginUser = WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"userCode"});
        }
        if (StringUtils.isBlank((CharSequence)loginUser)) {
            throw new ObjectException(302, controller.getI18nMessage("error.302.user_not_login", request, new Object[0]));
        }
        List userGroups = platformEnvironment.listWorkGroup(osId, loginUser, null);
        if (CollectionUtils.isEmpty((Collection)userGroups)) {
            throw new ObjectException(203, controller.getI18nMessage("error.403.access_forbidden", request, new Object[0]));
        }
    }
}

