/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.controller;

import com.centit.dde.po.DataPacketTemplate;
import com.centit.dde.services.DataPacketTemplateService;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.filter.RequestThreadLocal;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"API\u6a21\u677f\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/template/"})
public class DataPacketTemplateController
extends BaseController {
    @Autowired
    DataPacketTemplateService dataPacketTemplateService;

    @ApiOperation(value="\u65b0\u589eAPI\u6a21\u677f")
    @PutMapping
    @WrapUpResponseBody
    public DataPacketTemplate createDataPacketTemplate(@RequestBody DataPacketTemplate dataPacketTemplate) {
        String loginUser = WebOptUtils.getCurrentUserCode((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest());
        if (StringBaseOpt.isNvl((String)loginUser)) {
            loginUser = WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest(), (String[])new String[]{"userCode"});
        }
        dataPacketTemplate.setCreateUser(loginUser);
        this.dataPacketTemplateService.createDataPacketTemplate(dataPacketTemplate);
        return dataPacketTemplate;
    }

    @ApiOperation(value="\u4fee\u6539API\u6a21\u677f")
    @PostMapping
    @WrapUpResponseBody
    public void updateDataPacketTemplate(@RequestBody DataPacketTemplate dataPacketTemplate) {
        this.dataPacketTemplateService.updateDataPacketTemplate(dataPacketTemplate);
    }

    @ApiOperation(value="\u4fee\u6539API\u6a21\u677f")
    @PostMapping(value={"{templateId}"})
    @WrapUpResponseBody
    public void updateDataPacketTemplateContent(@PathVariable String templateId, @RequestBody String content) {
        this.dataPacketTemplateService.updateDataPacketTemplateContent(templateId, content);
    }

    @ApiOperation(value="\u5220\u9664API\u6a21\u677f")
    @DeleteMapping(value={"{templateId}"})
    @WrapUpResponseBody
    public void deleteDataPacketTemplate(@PathVariable String templateId) {
        this.dataPacketTemplateService.deleteDataPacketTemplate(templateId);
    }

    @ApiOperation(value="\u83b7\u53d6API\u6a21\u677f\u5217\u8868")
    @GetMapping
    @WrapUpResponseBody
    public List<DataPacketTemplate> listDataPacketTemplate(Map<String, Object> params, PageDesc pageDesc) {
        return this.dataPacketTemplateService.listDataPacketTemplate(params, pageDesc);
    }
}

