/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.controller;

import com.alibaba.fastjson.JSONArray;
import com.centit.dde.services.GenerateFieldsService;
import com.centit.dde.vo.ColumnSchema;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.support.common.ObjectException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u83b7\u53d6\u5217\u67e5\u8be2", tags={"\u5217\u67e5\u8be2"})
@RestController
@RequestMapping(value={"query"})
public class GenerateFieldsController
extends BaseController {
    private final GenerateFieldsService generateFieldsService;

    @Autowired
    public GenerateFieldsController(GenerateFieldsService generateFieldsService) {
        this.generateFieldsService = generateFieldsService;
    }

    @ApiOperation(value="\u9884\u89c8\u6570\u636e\u503c\u8fd4\u56de\u524d20\u884c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="databaseCode", value="C:csv;J:json;\u5176\u4ed6\u4e3a\u6570\u636e\u5e93", required=true), @ApiImplicitParam(name="sql", value="C,J:fileId;\u5176\u4ed6sql\u67e5\u8be2", required=true)})
    @RequestMapping(value={"/previewdata"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public JSONArray queryViewSqlData(String databaseCode, String sql, HttpServletRequest request) {
        Map params = GenerateFieldsController.collectRequestParameters((HttpServletRequest)request);
        try {
            switch (databaseCode) {
                case "C": {
                    return this.generateFieldsService.queryViewCsvData(sql);
                }
                case "J": {
                    return this.generateFieldsService.queryViewJsonData(sql);
                }
            }
            return this.generateFieldsService.queryViewSqlData(databaseCode, StringEscapeUtils.unescapeHtml4((String)sql), params);
        }
        catch (Exception e) {
            throw new ObjectException((Throwable)e);
        }
    }

    @ApiOperation(value="\u751f\u6210\u67e5\u8be2\u5b57\u6bb5\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataType", value="C:csv;J:json;D:\u6570\u636e\u5e93", required=true), @ApiImplicitParam(name="sql", value="C,J:fileId;\u5176\u4ed6sql\u67e5\u8be2", required=true)})
    @RequestMapping(value={"/sqlcolumn"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public List<ColumnSchema> generateSqlColumn(String databaseCode, String sql, String dataType, HttpServletRequest request) throws IOException {
        sql = StringEscapeUtils.unescapeHtml4((String)sql);
        Map params = GenerateFieldsController.collectRequestParameters((HttpServletRequest)request);
        switch (dataType) {
            case "C": {
                params.put("FileId", sql);
                return this.generateFieldsService.generateCsvFields(params);
            }
            case "J": {
                return this.generateFieldsService.generateJsonFields(params);
            }
            case "D": {
                return this.generateFieldsService.generateSqlFields(databaseCode, sql, params);
            }
            case "P": {
                return this.generateFieldsService.generatePostFields(sql);
            }
        }
        return Collections.emptyList();
    }

    @ApiOperation(value="\u751f\u6210\u53c2\u6570\u540d\u79f0\u5217\u8868")
    @ApiImplicitParam(name="sql", value="\u67e5\u8be2SQL", required=true)
    @RequestMapping(value={"/param"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public JSONArray generateParam(String sql) {
        Set sets = this.generateFieldsService.generateSqlParams(sql);
        JSONArray jsonArray = new JSONArray();
        for (String key : sets) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("key", key);
            map.put("value", "");
            jsonArray.add(map);
        }
        return jsonArray;
    }
}

