/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.dde.po.DataPacketDraft;
import com.centit.dde.services.DataPacketDraftService;
import com.centit.dde.services.DataPacketService;
import com.centit.dde.services.DataPacketTemplateService;
import com.centit.dde.utils.LoginUserPermissionCheck;
import com.centit.dde.vo.HttpParameter;
import com.centit.dde.vo.MetaDataParameter;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.filter.RequestThreadLocal;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u672a\u53d1\u5e03API\u7f51\u5173\u63a5\u53e3\u7ba1\u7406", tags={"\u672a\u53d1\u5e03API\u7f51\u5173\u63a5\u53e3\u7ba1\u7406"})
@RestController
@RequestMapping(value={"packetDraft"})
public class DataPacketDraftController
extends BaseController {
    private final DataPacketDraftService dataPacketDraftService;
    @Autowired
    private DataPacketTemplateService dataPacketTemplateService;
    @Autowired
    private DataPacketService dataPacketService;
    @Autowired
    private PlatformEnvironment platformEnvironment;

    public DataPacketDraftController(DataPacketDraftService dataPacketDraftService) {
        this.dataPacketDraftService = dataPacketDraftService;
    }

    @ApiOperation(value="\u65b0\u589eAPI\u7f51\u5173")
    @PostMapping
    @WrapUpResponseBody
    public DataPacketDraft createDataPacket(@RequestBody DataPacketDraft dataPacketDraft, HttpServletRequest request) {
        LoginUserPermissionCheck.loginUserPermissionCheck(this.platformEnvironment, dataPacketDraft.getOsId());
        dataPacketDraft.setRecorder(WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        dataPacketDraft.setDataOptDescJson(dataPacketDraft.getDataOptDescJson());
        this.dataPacketDraftService.createDataPacket(dataPacketDraft);
        return dataPacketDraft;
    }

    @ApiOperation(value="\u65b0\u589eHTTP\u8c03\u7528\u7c7b\u578bAPI")
    @PostMapping(value={"/http-type"})
    @WrapUpResponseBody
    @Transactional(rollbackFor={Exception.class})
    public DataPacketDraft createHttpTypeApi(@RequestBody HttpParameter httpParames) {
        DataPacketDraft dataPacketDraft = new DataPacketDraft();
        dataPacketDraft.setOsId(httpParames.getOsId());
        LoginUserPermissionCheck.loginUserPermissionCheck(this.platformEnvironment, dataPacketDraft.getOsId());
        String loginUser = WebOptUtils.getCurrentUserCode((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest());
        if (StringBaseOpt.isNvl((String)loginUser)) {
            loginUser = WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest(), (String[])new String[]{"userCode"});
        }
        dataPacketDraft.setRecorder(loginUser);
        JSONObject dataPacketTemplate = this.dataPacketTemplateService.getDataPacketTemplateByType(Integer.valueOf(8));
        JSONObject content = dataPacketTemplate.getJSONObject("content");
        String taskType = content.getString("taskType");
        JSONArray nodes = content.getJSONArray("nodes");
        for (Object node : nodes) {
            JSONObject nodeData = (JSONObject)node;
            JSONObject properties = nodeData.getJSONObject("properties");
            if (!"htts".equals(properties.getString("type"))) continue;
            if (StringUtils.isNotBlank((CharSequence)httpParames.getRequestBody())) {
                properties.put("querySQL", (Object)httpParames.getRequestBody());
            }
            if (httpParames.getParamesList() != null && httpParames.getParamesList().length > 0) {
                properties.put("parameterList", (Object)httpParames.getParamesList());
            }
            properties.put("httpUrl", (Object)httpParames.getMethodName());
            properties.put("loginService", (Object)httpParames.getLoginUrlCode());
            properties.put("requestMode", (Object)httpParames.getMethodType());
            properties.put("databaseId", (Object)httpParames.getHttpUrlCode());
        }
        JSONObject schemaProps = dataPacketTemplate.getJSONObject("schemaProps");
        dataPacketDraft.setSchemaProps(schemaProps);
        dataPacketDraft.setBufferFreshPeriod(Integer.valueOf(-1));
        dataPacketDraft.setIsValid(Boolean.valueOf(true));
        dataPacketDraft.setTaskType(taskType);
        dataPacketDraft.setOptId(httpParames.getOptId());
        dataPacketDraft.setOsId(httpParames.getOsId());
        dataPacketDraft.setLogLevel(Integer.valueOf(3));
        dataPacketDraft.setPacketName(httpParames.getPacketName());
        dataPacketDraft.setPacketDesc(httpParames.getPacketName());
        dataPacketDraft.setDataOptDescJson(content);
        this.dataPacketDraftService.createDataPacket(dataPacketDraft);
        return dataPacketDraft;
    }

    @ApiOperation(value="\u65b0\u589e\u5143\u6570\u636e\u7c7b\u578bAPI")
    @PostMapping(value={"/metadata/api"})
    @WrapUpResponseBody
    @Transactional(rollbackFor={Exception.class})
    public List<DataPacketDraft> createMetaDataApi(@RequestBody MetaDataParameter metaDataOrHttpParams) {
        Integer[] createType;
        DataPacketDraft dataPacket = new DataPacketDraft();
        dataPacket.setOsId(metaDataOrHttpParams.getOsId());
        LoginUserPermissionCheck.loginUserPermissionCheck(this.platformEnvironment, dataPacket.getOsId());
        String loginUser = WebOptUtils.getCurrentUserCode((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest());
        if (StringBaseOpt.isNvl((String)loginUser)) {
            loginUser = WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest(), (String[])new String[]{"userCode"});
        }
        ArrayList<DataPacketDraft> dataPacketDraftList = new ArrayList<DataPacketDraft>();
        for (Integer type : createType = metaDataOrHttpParams.getCreateType()) {
            DataPacketDraft dataPacketDraft = this.createDataPacket(metaDataOrHttpParams, type);
            dataPacketDraft.setRecorder(loginUser);
            this.dataPacketDraftService.createDataPacket(dataPacketDraft);
            dataPacketDraftList.add(dataPacketDraft);
        }
        return dataPacketDraftList;
    }

    private DataPacketDraft createDataPacket(MetaDataParameter metaDataOrHttpParams, Integer type) {
        DataPacketDraft dataPacketDraft = new DataPacketDraft();
        dataPacketDraft.setBufferFreshPeriod(Integer.valueOf(-1));
        dataPacketDraft.setIsValid(Boolean.valueOf(true));
        dataPacketDraft.setTemplateType(type);
        dataPacketDraft.setOptId(metaDataOrHttpParams.getOptId());
        dataPacketDraft.setOsId(metaDataOrHttpParams.getOsId());
        JSONObject dataPacketTemplate = this.dataPacketTemplateService.getDataPacketTemplateByType(type);
        String tableName = metaDataOrHttpParams.getTableName();
        String packetTemplateName = dataPacketTemplate.getString("packetTemplateName");
        String replace = packetTemplateName.replace("{name}", tableName);
        dataPacketDraft.setTaskType(dataPacketTemplate.getString("taskType"));
        dataPacketDraft.setPacketName(replace);
        dataPacketDraft.setPacketDesc(replace);
        String dataBaseCode = metaDataOrHttpParams.getDatabaseCode();
        String tableId = metaDataOrHttpParams.getTableId();
        JSONObject content = dataPacketTemplate.getJSONObject("content");
        JSONArray nodes = content.getJSONArray("nodes");
        for (Object node : nodes) {
            JSONObject nodeData = (JSONObject)node;
            JSONObject properties = nodeData.getJSONObject("properties");
            String metadataType = properties.getString("type");
            if (!StringUtils.isNotBlank((CharSequence)metadataType) || !metadataType.startsWith("metadata")) continue;
            properties.put("tableId", (Object)tableId);
            properties.put("templateType", (Object)(type == 6 || type == 7 ? 1 : type));
            properties.put("databaseName", (Object)dataBaseCode);
        }
        JSONObject schemaProps = dataPacketTemplate.getJSONObject("schemaProps");
        dataPacketDraft.setSchemaProps(schemaProps);
        dataPacketDraft.setMetadataTableId(tableId);
        dataPacketDraft.setLogLevel(Integer.valueOf(3));
        dataPacketDraft.setNeedRollback("T");
        dataPacketDraft.setDataOptDescJson(content);
        return dataPacketDraft;
    }

    @ApiOperation(value="\u7f16\u8f91API\u7f51\u5173")
    @ApiImplicitParam(name="packetId", value="apiID\u53f7", required=true, paramType="path", dataType="String")
    @PutMapping(value={"/{packetId}"})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0api", tag="{arg0}", newValue="\u65e0")
    @WrapUpResponseBody
    public void updateDataPacket(@PathVariable String packetId, @RequestBody DataPacketDraft dataPacketDraft) throws ParseException {
        if (dataPacketDraft == null) {
            throw new ObjectException(412, "\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        LoginUserPermissionCheck.loginUserPermissionCheck(this.platformEnvironment, dataPacketDraft.getOsId());
        dataPacketDraft.setPacketId(packetId);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateStr = dateFormat.format(new Date());
        dataPacketDraft.setUpdateDate(dateFormat.parse(dateStr));
        dataPacketDraft.setDataOptDescJson(dataPacketDraft.getDataOptDescJson());
        this.dataPacketDraftService.updateDataPacket(dataPacketDraft);
    }

    @ApiOperation(value="API\u7f51\u5173\u53d1\u5e03")
    @PutMapping(value={"publish/{packetId}"})
    @WrapUpResponseBody
    @Transactional(rollbackFor={Exception.class})
    public void publishDataPacket(@PathVariable String packetId) throws ParseException {
        DataPacketDraft dataPacketDraft = this.dataPacketDraftService.getDataPacket(packetId);
        if (dataPacketDraft == null) {
            throw new ObjectException(412, "\u53d1\u5e03\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        LoginUserPermissionCheck.loginUserPermissionCheck(this.platformEnvironment, dataPacketDraft.getOsId());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateStr = simpleDateFormat.format(new Date());
        dataPacketDraft.setPublishDate(simpleDateFormat.parse(dateStr));
        this.dataPacketDraftService.publishDataPacket(dataPacketDraft);
    }

    @ApiOperation(value="\u7f16\u8f91API\u7f51\u5173\u6570\u636e\u5904\u7406\u63cf\u8ff0\u4fe1\u606f")
    @PutMapping(value={"/opt/{packetId}"})
    @WrapUpResponseBody
    public void updateDataPacketOpt(@PathVariable String packetId, @RequestBody String dataOptDescJson) {
        DataPacketDraft dataPacketDraft = this.dataPacketDraftService.getDataPacket(packetId);
        if (dataPacketDraft == null) {
            throw new ObjectException(412, "\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        LoginUserPermissionCheck.loginUserPermissionCheck(this.platformEnvironment, dataPacketDraft.getOsId());
        this.dataPacketDraftService.updateDataPacketOptJson(packetId, dataOptDescJson);
    }

    @ApiOperation(value="\u7269\u7406\u5220\u9664API\u7f51\u5173")
    @DeleteMapping(value={"/{packetId}"})
    @WrapUpResponseBody
    @Transactional(rollbackFor={Exception.class})
    public void deleteDataPacket(@PathVariable String packetId) {
        DataPacketDraft dataPacketDraft = this.dataPacketDraftService.getDataPacket(packetId);
        if (dataPacketDraft == null) {
            throw new ObjectException(412, "\u5220\u9664\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        LoginUserPermissionCheck.loginUserPermissionCheck(this.platformEnvironment, dataPacketDraft.getOsId());
        this.platformEnvironment.deleteOptDefAndRolepowerByOptCode(dataPacketDraft.getOptCode());
        this.dataPacketService.deleteDataPacket(packetId);
        this.dataPacketDraftService.deleteDataPacket(packetId);
    }

    @ApiOperation(value="\u4fee\u6539API\u53ef\u7528\u72b6\u6001(T:\u7981\u7528\uff0cF:\u542f\u7528)")
    @PutMapping(value={"/{packetId}/{disableType}"})
    @WrapUpResponseBody
    @Transactional(rollbackFor={Exception.class})
    public void updateDisableStatus(@PathVariable String packetId, @PathVariable String disableType) {
        DataPacketDraft dataPacketDraft = this.dataPacketDraftService.getDataPacket(packetId);
        if (dataPacketDraft == null) {
            throw new ObjectException(412, "\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        LoginUserPermissionCheck.loginUserPermissionCheck(this.platformEnvironment, dataPacketDraft.getOsId());
        if ("F".equals(disableType)) {
            this.dataPacketService.updateDisableStatus(packetId, disableType);
            this.dataPacketDraftService.updateDisableStatus(packetId, disableType);
        } else if ("T".equals(disableType)) {
            this.dataPacketService.updateDisableStatus(packetId, disableType);
            this.dataPacketDraftService.updateDisableStatus(packetId, disableType);
        } else {
            throw new ObjectException(412, "\u975e\u6cd5\u4f20\u53c2\uff0c\u53c2\u6570\u5fc5\u987b\u4e3aT\u6216F,\u4f20\u5165\u7684\u53c2\u6570\u4e3a\uff1a" + disableType);
        }
        this.platformEnvironment.deleteOptDefAndRolepowerByOptCode(dataPacketDraft.getOptCode());
    }

    @ApiOperation(value="\u67e5\u8be2API\u7f51\u5173")
    @GetMapping
    @WrapUpResponseBody
    public PageQueryResult<Map<String, Object>> listDataPacket(HttpServletRequest request, PageDesc pageDesc) {
        List list = this.dataPacketDraftService.listDataPacket(BaseController.collectRequestParameters((HttpServletRequest)request), pageDesc);
        ArrayList returnList = new ArrayList();
        list.stream().forEach(dataPacketDraft -> {
            String optId = dataPacketDraft.getOptId();
            Map dataPacketInfo = CollectionsOpt.objectToMap((Object)dataPacketDraft);
            String optName = CodeRepositoryUtil.getValue((String)"optId", (String)optId);
            dataPacketInfo.put("optName", optName);
            returnList.add(dataPacketInfo);
        });
        return PageQueryResult.createResult(returnList, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2aAPI\u7f51\u5173")
    @GetMapping(value={"/{packetId}"})
    @WrapUpResponseBody
    public DataPacketDraft getDataPacket(@PathVariable String packetId) {
        DataPacketDraft dataPacketDraft = this.dataPacketDraftService.getDataPacket(packetId);
        if (dataPacketDraft != null && dataPacketDraft.getIsDisable().booleanValue()) {
            return null;
        }
        return dataPacketDraft;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u548c\u6e05\u7a7a\u56de\u6536\u7ad9")
    @PostMapping(value={"/batchDeleteByPacketIds"})
    @ApiImplicitParam(name="jsonObject", value="\u6279\u91cf\u5220\u9664-\u53c2\u6570\uff1a{packetIds:[\"packetId\"],osId:\"osId\"};\u6e05\u7a7a\u56de\u6536\u7ad9-\u53c2\u6570\uff1a{osId:\"osId\"}")
    @WrapUpResponseBody
    public void batchDeleteByPacketIds(@RequestBody JSONObject jsonObject) {
        JSONArray packetIds = jsonObject.getJSONArray("packetIds");
        String osId = jsonObject.getString("osId");
        LoginUserPermissionCheck.loginUserPermissionCheck(this.platformEnvironment, osId);
        if (packetIds != null && packetIds.size() > 0) {
            String[] ids = (String[])packetIds.toArray((Object[])new String[packetIds.size()]);
            this.dataPacketDraftService.batchDeleteByPacketIds(ids);
            this.dataPacketService.batchDeleteByPacketIds(ids);
        } else if (!StringBaseOpt.isNvl((String)osId)) {
            this.dataPacketDraftService.clearTrashStand(osId);
            this.dataPacketService.clearTrashStand(osId);
        }
    }

    @ApiOperation(value="API\u590d\u5236\u63a5\u53e3")
    @PostMapping(value={"/ApiCopy"})
    @ApiImplicitParam(name="jsonObject", value="API\u590d\u5236\u63a5\u53e3-\u53c2\u6570\uff1a{\"packetId\":\"\",\"packetName\":\"\",\"optId\":\"\"}")
    @WrapUpResponseBody
    public ResponseData ApiCopy(@RequestBody JSONObject jsonObject) {
        String packetId = jsonObject.getString("packetId");
        String packetName = jsonObject.getString("packetName");
        String optId = jsonObject.getString("optId");
        if (StringUtils.isBlank((CharSequence)packetId) || StringUtils.isBlank((CharSequence)packetName) || StringUtils.isBlank((CharSequence)optId)) {
            return ResponseData.makeErrorMessage((String)"\u7f3a\u5c11\u53c2\u6570\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01");
        }
        DataPacketDraft dataPacket = this.dataPacketDraftService.getDataPacket(packetId);
        if (dataPacket == null) {
            return ResponseData.makeErrorMessage((String)"\u590d\u5236\u7684API\u63a5\u53e3\u4e0d\u5b58\u5728\uff01");
        }
        LoginUserPermissionCheck.loginUserPermissionCheck(this.platformEnvironment, dataPacket.getOsId());
        dataPacket.setPacketId(null);
        dataPacket.setPacketName(packetName);
        dataPacket.setOptId(optId);
        this.dataPacketDraftService.createDataPacket(dataPacket);
        return ResponseData.successResponse;
    }
}

