/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.controller;

import com.alibaba.fastjson.JSON;
import com.centit.dde.core.DataSet;
import com.centit.dde.dataset.ExcelDataSet;
import com.centit.dde.po.DataPacket;
import com.centit.dde.po.DataPacketCopy;
import com.centit.dde.service.ExchangeService;
import com.centit.dde.services.DataPacketCopyService;
import com.centit.dde.services.DataPacketService;
import com.centit.dde.utils.DataSetOptUtil;
import com.centit.fileserver.utils.UploadDownloadUtils;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.compiler.ObjectTranslate;
import com.centit.support.compiler.VariableFormula;
import com.centit.support.compiler.VariableTranslate;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="Http\u89e6\u53d1\u4efb\u52a1\u54cd\u5e94", tags={"Http\u89e6\u53d1\u4efb\u52a1\u54cd\u5e94"})
@RestController
@RequestMapping(value={"httpTask"})
public class HttpTaskController
extends BaseController {
    private final DataPacketService dataPacketService;
    private final DataPacketCopyService dataPacketCopyService;
    private final ExchangeService exchangeService;

    public HttpTaskController(DataPacketService dataPacketService, DataPacketCopyService dataPacketCopyService, ExchangeService exchangeService) {
        this.dataPacketService = dataPacketService;
        this.dataPacketCopyService = dataPacketCopyService;
        this.exchangeService = exchangeService;
    }

    @GetMapping(value={"/runTest/{packetId}"})
    @ApiOperation(value="\u6d4b\u8bd5\uff1a\u7acb\u5373\u6267\u884c\u4efb\u52a1")
    public void runTestTaskExchange(@PathVariable String packetId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.returnObject(packetId, "D", request, response);
    }

    @GetMapping(value={"/debugRunTest/{packetId}"})
    @ApiOperation(value="\u6d4b\u8bd5\uff1aDEBUG\u6267\u884c\u4efb\u52a1")
    public void debugRunTestTaskExchange(@PathVariable String packetId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.returnObject(packetId, "D", request, response);
    }

    @GetMapping(value={"/run/{packetId}"})
    @ApiOperation(value="\u6b63\u5f0f\uff1a\u7acb\u5373\u6267\u884c\u4efb\u52a1")
    public void runTaskExchange(@PathVariable String packetId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.returnObject(packetId, "N", request, response);
    }

    @GetMapping(value={"/debugRun/{packetId}"})
    @ApiOperation(value="\u6b63\u5f0f\uff1aDEBUG\u6267\u884c\u4efb\u52a1")
    public void debugRunTaskExchange(@PathVariable String packetId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.returnObject(packetId, "N", request, response);
    }

    private void returnObject(String packetId, String runType, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Object bizModel;
        Map params = HttpTaskController.collectRequestParameters((HttpServletRequest)request);
        params.put("runType", runType);
        if (!"GET".equals(request.getMethod())) {
            if (StringUtils.contains((CharSequence)request.getHeader("content-type"), (CharSequence)"application")) {
                String bodyString = FileIOOpt.readStringFromInputStream((InputStream)request.getInputStream(), (String)String.valueOf(Charset.forName("utf-8")));
                if (!StringBaseOpt.isNvl((String)bodyString)) {
                    params.put("requestBody", bodyString);
                }
            } else {
                InputStream inputStream = (InputStream)UploadDownloadUtils.fetchInputStreamFromMultipartResolver((HttpServletRequest)request).getRight();
                if (inputStream != null) {
                    params.put("requestFile", inputStream);
                }
            }
        }
        if ("N".equals(runType)) {
            DataPacket dataPacket = this.dataPacketService.getDataPacket(packetId);
            bizModel = this.dataPacketService.fetchDataPacketDataFromBuf(dataPacket, params);
            if (bizModel == null) {
                bizModel = this.exchangeService.runTask(packetId, params);
                this.dataPacketService.setDataPacketBuf(bizModel, dataPacket, params);
            }
        } else {
            DataPacketCopy dataPacketCopy = this.dataPacketCopyService.getDataPacket(packetId);
            bizModel = this.dataPacketCopyService.fetchDataPacketDataFromBuf(dataPacketCopy, params);
            if (bizModel == null) {
                bizModel = this.exchangeService.runTask(packetId, params);
                this.dataPacketCopyService.setDataPacketBuf(bizModel, dataPacketCopy, params);
            }
        }
        if (bizModel instanceof DataSet) {
            InputStream in;
            Map mapFirstRow = ((DataSet)bizModel).getFirstRow();
            if (mapFirstRow != null && mapFirstRow.containsKey("fileContent") && mapFirstRow.get("fileContent") instanceof OutputStream) {
                ByteArrayOutputStream outputStream = (ByteArrayOutputStream)((DataSet)bizModel).getFirstRow().get("fileContent");
                in = new ByteArrayInputStream(outputStream.toByteArray());
                String fileName = (String)((DataSet)bizModel).getFirstRow().get("fileName");
                UploadDownloadUtils.downFileRange((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)in, (long)in.available(), (String)fileName, (String)request.getParameter("downloadType"), null);
                return;
            }
            if (((DataSet)bizModel).getData() instanceof InputStream) {
                in = (InputStream)((DataSet)bizModel).getData();
                List inputStreamList = ExcelDataSet.cloneInputStream((InputStream)in);
                String fileType = FileType.getFileType((InputStream)((InputStream)inputStreamList.get(0)));
                fileType = StringUtils.isNotBlank((CharSequence)fileType) ? fileType : ".temp";
                String fileName = System.currentTimeMillis() + "." + fileType;
                UploadDownloadUtils.downFileRange((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)((InputStream)inputStreamList.get(1)), (long)((InputStream)inputStreamList.get(1)).available(), (String)fileName, (String)request.getParameter("downloadType"), null);
                return;
            }
        }
        JsonResultUtils.writeSingleDataJson((Object)bizModel, (HttpServletResponse)response);
    }

    @PostMapping(value={"/runPostTest/{packetId}"})
    @ApiOperation(value="\u6d4b\u8bd5\uff1a\u7acb\u5373\u6267\u884c\u4efb\u52a1Post")
    public void runTaskPostTest(@PathVariable String packetId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.returnObject(packetId, "D", request, response);
    }

    @PostMapping(value={"/runPost/{packetId}"})
    @ApiOperation(value="\u6b63\u5f0f\uff1a\u7acb\u5373\u6267\u884c\u4efb\u52a1Post")
    public void runTaskPost(@PathVariable String packetId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.returnObject(packetId, "N", request, response);
    }

    @GetMapping(value={"/testformula"})
    @ApiOperation(value="\u6d4b\u8bd5\u8868\u8fbe\u5f0f", notes="\u53ef\u7528\u8868\u8fbe\u5f0f  \n\u8868\u8fbe\u5f0f:toJson(),\u540d\u79f0:\u8f6cjson,\u793a\u4f8b:formula:toJson(name);json:{name:\\{sex:'man'}}  \n\u8868\u8fbe\u5f0f:uuid(),\u540d\u79f0:\u83b7\u53d6uuid,\u793a\u4f8b:formula:uuid()  \n\u8868\u8fbe\u5f0f:toString(),\u540d\u79f0:\u8f6c\u6362\u4e3aString,\u793a\u4f8b:formula:toString(name)  \n\u8868\u8fbe\u5f0f:attr(),\u540d\u79f0:\u83b7\u53d6\u5bf9\u8c61\u5c5e\u6027,\u793a\u4f8b:formula:attr(name,'123')  \n\u8868\u8fbe\u5f0f:getat(),\u793a\u4f8b:\u6c42\u6570\u7ec4\u4e2d\u7684\u4e00\u4e2a\u503c,\u793a\u4f8b:formula:getat (0,\"a\",\"b\")  \n\u8868\u8fbe\u5f0f:singleton(),\u540d\u79f0:\u8fd4\u56de\u96c6\u5408\uff0c\u53bb\u91cd,\u793a\u4f8b:formula:singleton(name)  \n\u8868\u8fbe\u5f0f:getpy(),\u540d\u79f0:\u53d6\u6c49\u5b57\u62fc\u97f3,\u793a\u4f8b:formula:getpy(name)  \n\u8868\u8fbe\u5f0f:byte(),\u540d\u79f0:\u6c42\u4f4d\u503c,\u793a\u4f8b:formula:byte(4321.789,0)  \n\u8868\u8fbe\u5f0f:capital(),\u540d\u79f0:\u6570\u5b57\u8f6c\u5927\u5199,\u793a\u4f8b:formula:capital(123.45)  \n\u8868\u8fbe\u5f0f:if(),\u540d\u79f0:\u4e09\u76ee\u5224\u65ad,\u793a\u4f8b:formula:if(name=='b','c','d');json:{name:'a'}  \n\u8868\u8fbe\u5f0f:case(),\u540d\u79f0:swithcase\u5224\u65ad,\u793a\u4f8b:formula:case(name,'b','c','d','e')  \n\u8868\u8fbe\u5f0f:regexmatch(),\u540d\u79f0:\u5339\u914d\u5224\u65ad,*?\u4e3a\u901a\u914d\u7b26,\u793a\u4f8b:formula:regexmatch('t??t',name)  \n\u8868\u8fbe\u5f0f:regexmatchvalue(),\u540d\u79f0:\u83b7\u53d6\u5339\u914d\u503c,\u793a\u4f8b:formula:regexmatchvalue('t??t',name)  \n\u8868\u8fbe\u5f0f:count(),\u540d\u79f0:\u8ba1\u6570,\u793a\u4f8b:formula:count(1,\"2\",3,\"5\",1,1,4)  \n\u8868\u8fbe\u5f0f:countnotnull(),\u540d\u79f0:\u8ba1\u6570 \u975e\u7a7a\u53c2\u6570,\u793a\u4f8b:formula:countnotnull(1,,\"2\",,,,1,1,4)  \n\u8868\u8fbe\u5f0f:countnull(),\u540d\u79f0:\u8ba1\u6570\u7a7a\u53c2\u6570,\u793a\u4f8b:formula:countnull(1,,\"2\",,,,1,1,4)  \n\u8868\u8fbe\u5f0f:concat(),\u540d\u79f0:\u8fde\u63a5\u5b57\u7b26\u4e32,\u793a\u4f8b:formula:concat('a','b')  \n\u8868\u8fbe\u5f0f:isempty(),\u540d\u79f0:\u5224\u65ad\u53c2\u6570\u662f\u5426\u4e3a\u7a7a,\u793a\u4f8b:formula:isempty(name)  \n\u8868\u8fbe\u5f0f:isnotempty(),\u540d\u79f0:\u5224\u65ad\u53c2\u6570\u662f\u5426\u975e\u7a7a,\u793a\u4f8b:formula:isnotempty(name)  \n\u8868\u8fbe\u5f0f:upcase(),\u540d\u79f0:\u5b57\u7b26\u4e32\u5927\u5199,\u793a\u4f8b:formula:upcase(name)  \n\u8868\u8fbe\u5f0f:lowcase(),\u540d\u79f0:\u5b57\u7b26\u4e32\u5c0f\u5199,\u793a\u4f8b:formula:lowcase(name)  \n\u8868\u8fbe\u5f0f:substr(),\u540d\u79f0:\u6c42\u5b57\u7b26\u4e32\u5b50\u4e32,\u793a\u4f8b:formula:substr(name,0,2)  \n\u8868\u8fbe\u5f0f:lpad(),\u540d\u79f0:\u5de6\u4fa7\u8865\u5145\u5b57\u7b26\u4e32,\u793a\u4f8b:formula:lpad(name,7,' ')  \n\u8868\u8fbe\u5f0f:rpad(),\u540d\u79f0:\u53f3\u4fa7\u8865\u5145\u5b57\u7b26\u4e32,\u793a\u4f8b:formula:rpad(name,7,' ')  \n\u8868\u8fbe\u5f0f:find(),\u540d\u79f0:\u6c42\u5b50\u4e32\u4f4d\u7f6e,\u793a\u4f8b:formula:find(name,'a')  \n\u8868\u8fbe\u5f0f:frequence(),\u540d\u79f0:\u6c42\u5b50\u4e32\u4e2a\u6570,\u793a\u4f8b:formula:frequence(name,'a')  \n\u8868\u8fbe\u5f0f:split(),\u540d\u79f0:\u5b57\u7b26\u4e32\u5927\u5199,\u793a\u4f8b:formula:split(name,',')  \n\u8868\u8fbe\u5f0f:toNumber(),\u540d\u79f0:\u8f6c\u6362\u4e3a\u6570\u5b57,\u793a\u4f8b:formula:toNumber(name)  \n\u8868\u8fbe\u5f0f:max(),\u540d\u79f0:\u6c42\u6700\u5927\u503c,\u793a\u4f8b:formula:max(1,2,3,5,4)  \n\u8868\u8fbe\u5f0f:min(),\u540d\u79f0:\u6c42\u6700\u5c0f\u503c,\u793a\u4f8b:formula:min(1,2,3,5,4)  \n\u8868\u8fbe\u5f0f:ave(),\u540d\u79f0:\u6c42\u5747\u503c,\u793a\u4f8b:formula:ave(1,2,3)  \n\u8868\u8fbe\u5f0f:sum(),\u540d\u79f0:\u6c42\u548c,\u793a\u4f8b:formula:sum(1,2,3,4,5)  \n\u8868\u8fbe\u5f0f:stddev(),\u540d\u79f0:\u6c42\u6807\u51c6\u504f\u5dee,\u793a\u4f8b:formula:stddev(1,2,3,5,4)  \n\u8868\u8fbe\u5f0f:round(),\u540d\u79f0:\u56db\u820d\u4e94\u5165,\u793a\u4f8b:formula:round(5.4)  \n\u8868\u8fbe\u5f0f:floor(),\u540d\u79f0:\u53d6\u6574,\u793a\u4f8b:formula:floor(5.6)  \n\u8868\u8fbe\u5f0f:ceil(),\u540d\u79f0:\u53d6\u6574+1,\u793a\u4f8b:formula:ceil(5.4)  \n\u8868\u8fbe\u5f0f:int(),\u540d\u79f0:\u6c42\u6574\u6570\u90e8\u5206,\u793a\u4f8b:formula:int(name)  \n\u8868\u8fbe\u5f0f:frac(),\u540d\u79f0:\u6c42\u5c0f\u6570\u90e8\u5206,\u793a\u4f8b:formula:frac(name)  \n\u8868\u8fbe\u5f0f:log(),\u540d\u79f0:\u6c42\u4ee510\u4e3a\u5e95\u7684\u5bf9\u6570,\u793a\u4f8b:formula:log(100)  \n\u8868\u8fbe\u5f0f:ln(),\u540d\u79f0:\u6c42\u81ea\u7136\u5bf9\u6570,\u793a\u4f8b:formula:ln(5.6)  \n\u8868\u8fbe\u5f0f:sin(),\u540d\u79f0:\u6c42\u6b63\u5f26,\u793a\u4f8b:formula:sin(100)  \n\u8868\u8fbe\u5f0f:cos(),\u540d\u79f0:\u6c42\u4f59\u5f26,\u793a\u4f8b:formula:cos(100)  \n\u8868\u8fbe\u5f0f:tan(),\u540d\u79f0:\u6c42\u6b63\u5207,\u793a\u4f8b:formula:tan(100)  \n\u8868\u8fbe\u5f0f:ctan(),\u540d\u79f0:\u6c42\u4f59\u5207,\u793a\u4f8b:formula:ctan(100)  \n\u8868\u8fbe\u5f0f:exp(),\u540d\u79f0:\u6c42\u4ee5e\u4e3a\u5e95\u7684\u6307\u6570,\u793a\u4f8b:formula:exp(100)  \n\u8868\u8fbe\u5f0f:sqrt(),\u540d\u79f0:\u6c42\u5e73\u65b9\u6839,\u793a\u4f8b:formula:sqrt(100)  \n\u8868\u8fbe\u5f0f:today(),\u540d\u79f0:\u5f53\u524d\u65e5\u671f\u5305\u62ec\u65f6\u95f4,\u793a\u4f8b:formula:today()  \n\u8868\u8fbe\u5f0f:currentDate(),\u540d\u79f0:\u5f53\u524d\u65e5\u671f,\u793a\u4f8b:formula:currentDate()  \n\u8868\u8fbe\u5f0f:day(),\u540d\u79f0:\u83b7\u53d6\u65e5,\u793a\u4f8b:formula:day()  \n\u8868\u8fbe\u5f0f:month(),\u540d\u79f0:\u83b7\u53d6\u6708,\u793a\u4f8b:formula:month()  \n\u8868\u8fbe\u5f0f:year(),\u540d\u79f0:\u83b7\u53d6\u5e74,\u793a\u4f8b:formula:year()  \n\u8868\u8fbe\u5f0f:week(),\u540d\u79f0:\u7b2c\u51e0\u5468,\u793a\u4f8b:formula:week()  \n\u8868\u8fbe\u5f0f:weekday(),\u540d\u79f0:\u661f\u671f\u51e0,\u793a\u4f8b:formula:weekday(name)  \n\u8868\u8fbe\u5f0f:formatdate(),\u540d\u79f0:\u683c\u5f0f\u5316\u65e5\u671f,\u793a\u4f8b:formula:formatdate(name)  \n\u8868\u8fbe\u5f0f:dayspan(),\u540d\u79f0:\u6c42\u4e24\u65e5\u671f\u4e4b\u95f4\u7684\u5929\u6570,\u793a\u4f8b:formula:dayspan(name,today())  \n\u8868\u8fbe\u5f0f:adddate(),\u540d\u79f0:\u52a0\u5929\u6570,\u793a\u4f8b:formula:adddate(name,1)  \n\u8868\u8fbe\u5f0f:addmonths(),\u540d\u79f0:\u52a0\u6708\u6570,\u793a\u4f8b:formula:addmonths(name,1)  \n\u8868\u8fbe\u5f0f:addyears(),\u540d\u79f0:\u52a0\u5e74\u6570,\u793a\u4f8b:formula:addyears(name,1)  \n\u8868\u8fbe\u5f0f:truncdate(),\u540d\u79f0:\u622a\u65ad\u65e5\u671f  \u7b2c\u4e8c\u4e2a\u53c2\u6570  Y \uff0cM , D \u5206\u522b\u8fd4\u56de\u4e00\u5e74\u3001\u6708\u7684\u7b2c\u4e00\u5929 \uff0c\u6216\u8005\u4e00\u65e5\u7684\u96f6\u70b9,\u793a\u4f8b:formula:truncdate(name,'y')  \n\u8868\u8fbe\u5f0f:lastofmonth(),\u540d\u79f0:\u6c42\u8fd9\u4e2a\u6708\u6700\u540e\u4e00\u5929,\u793a\u4f8b:formula:lastofmonth(name)  \n\u8868\u8fbe\u5f0f:toDate(),\u540d\u79f0:\u8f6c\u6362\u4e3a\u65e5\u671f,\u793a\u4f8b:formula:toDate(name)  \n")
    @ApiImplicitParams(value={@ApiImplicitParam(name="formula", value="\u8868\u8fbe\u5f0f"), @ApiImplicitParam(name="jsonString", value="\u9700\u8981\u6d4b\u8bd5\u7684\u5bf9\u8c61\uff0cjson\u683c\u5f0f")})
    @WrapUpResponseBody
    public Object testFormula(String formula, String jsonString) {
        Map object = (Map)JSON.parse((String)StringEscapeUtils.unescapeHtml4((String)jsonString));
        VariableFormula variableFormula = DataSetOptUtil.createFormula();
        variableFormula.setTrans((VariableTranslate)new ObjectTranslate((Object)object));
        variableFormula.setFormula(StringEscapeUtils.unescapeHtml4((String)formula));
        return variableFormula.calcFormula();
    }

    @GetMapping(value={"/test/{packetId}/{id}"})
    @ApiOperation(value="test")
    public void test(@PathVariable String packetId, @PathVariable String id, HttpServletRequest request, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)(packetId + ":" + id), (HttpServletResponse)response);
    }

    @GetMapping(value={"/test2/{packetId}"})
    @ApiOperation(value="test2")
    public void test2(@PathVariable String packetId, HttpServletRequest request, HttpServletResponse response) {
        JsonResultUtils.writeSingleDataJson((Object)packetId, (HttpServletResponse)response);
    }
}

