/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.webservice.restful;

import com.alibaba.fastjson.JSON;
import com.centit.dde.core.DataSet;
import com.centit.dde.dataset.ExcelDataSet;
import com.centit.dde.po.DataPacket;
import com.centit.dde.po.DataPacketCopy;
import com.centit.dde.service.ExchangeService;
import com.centit.dde.services.DataPacketCopyService;
import com.centit.dde.services.DataPacketService;
import com.centit.dde.webservice.RestFulPacketWebServices;
import com.centit.fileserver.utils.UploadDownloadUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.ContextLoaderListener;

@Path(value="/httpTask")
public class RestFulPacketWebServicesImpl
implements RestFulPacketWebServices {
    @Resource
    private WebServiceContext webServiceContext;

    @Override
    public void runTestTaskExchange(String packetId) throws IOException {
        MessageContext messageContext = this.webServiceContext.getMessageContext();
        HttpServletRequest request = (HttpServletRequest)messageContext.get((Object)"javax.xml.ws.servlet.request");
        HttpServletResponse response = (HttpServletResponse)messageContext.get((Object)"javax.xml.ws.servlet.response");
        this.returnObject(packetId, "N", request, response);
    }

    @Override
    public void debugRunTestTaskExchange(String packetId) {
        System.out.println(packetId);
    }

    @Override
    public void runTaskExchange(String packetId) {
        System.out.println(packetId);
    }

    @Override
    public void debugRunTaskExchange(String packetId) {
        System.out.println(packetId);
    }

    @Override
    public void runPostTest(String packetId) {
    }

    @Override
    public void runTaskPost(String packetId) {
        System.out.println(packetId);
    }

    private Object returnObject(String packetId, String runType, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Object bizModel;
        DataPacketService dataPacketService = (DataPacketService)ContextLoaderListener.getCurrentWebApplicationContext().getBean(DataPacketService.class);
        DataPacketCopyService dataPacketCopyService = (DataPacketCopyService)ContextLoaderListener.getCurrentWebApplicationContext().getBean(DataPacketCopyService.class);
        ExchangeService exchangeService = (ExchangeService)ContextLoaderListener.getCurrentWebApplicationContext().getBean(ExchangeService.class);
        Map params = BaseController.collectRequestParameters((HttpServletRequest)request);
        params.put("runType", runType);
        if (!"GET".equals(request.getMethod())) {
            if (StringUtils.contains((CharSequence)request.getHeader("content-type"), (CharSequence)"application")) {
                String bodyString = FileIOOpt.readStringFromInputStream((InputStream)request.getInputStream(), (String)String.valueOf(Charset.forName("utf-8")));
                if (!StringBaseOpt.isNvl((String)bodyString)) {
                    params.put("requestBody", bodyString);
                }
            } else {
                InputStream inputStream = (InputStream)UploadDownloadUtils.fetchInputStreamFromMultipartResolver((HttpServletRequest)request).getRight();
                if (inputStream != null) {
                    params.put("requestFile", inputStream);
                }
            }
        }
        if ("N".equals(runType)) {
            DataPacket dataPacket = dataPacketService.getDataPacket(packetId);
            bizModel = dataPacketService.fetchDataPacketDataFromBuf(dataPacket, params);
            if (bizModel == null) {
                bizModel = exchangeService.runTask(packetId, params);
                dataPacketService.setDataPacketBuf(bizModel, dataPacket, params);
            }
        } else {
            DataPacketCopy dataPacketCopy = dataPacketCopyService.getDataPacket(packetId);
            bizModel = dataPacketCopyService.fetchDataPacketDataFromBuf(dataPacketCopy, params);
            if (bizModel == null) {
                bizModel = exchangeService.runTask(packetId, params);
                dataPacketCopyService.setDataPacketBuf(bizModel, dataPacketCopy, params);
            }
        }
        if (bizModel instanceof DataSet) {
            InputStream in;
            if (((DataSet)bizModel).getFirstRow().containsKey("fileContent") && ((DataSet)bizModel).getFirstRow().get("fileContent") instanceof OutputStream) {
                ByteArrayOutputStream outputStream = (ByteArrayOutputStream)((DataSet)bizModel).getFirstRow().get("fileContent");
                in = new ByteArrayInputStream(outputStream.toByteArray());
                String fileName = (String)((DataSet)bizModel).getFirstRow().get("fileName");
                UploadDownloadUtils.downFileRange((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)in, (long)in.available(), (String)fileName, (String)request.getParameter("downloadType"), null);
                return null;
            }
            if (((DataSet)bizModel).getData() instanceof InputStream) {
                in = (InputStream)((DataSet)bizModel).getData();
                List inputStreamList = ExcelDataSet.cloneInputStream((InputStream)in);
                String fileType = FileType.getFileType((InputStream)((InputStream)inputStreamList.get(0)));
                fileType = StringUtils.isNotBlank((CharSequence)fileType) ? fileType : ".temp";
                String fileName = System.currentTimeMillis() + "." + fileType;
                UploadDownloadUtils.downFileRange((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)((InputStream)inputStreamList.get(1)), (long)((InputStream)inputStreamList.get(1)).available(), (String)fileName, (String)request.getParameter("downloadType"), null);
                return null;
            }
        }
        return JSON.toJSONString((Object)bizModel);
    }
}

