/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.controller;

import com.centit.dde.po.DataPacketCopy;
import com.centit.dde.services.DataPacketCopyService;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="COPY\u6570\u636e\u5305", tags={"COPY\u6570\u636e\u5305"})
@RestController
@RequestMapping(value={"packetCopy"})
public class DataPacketCopyController
extends BaseController {
    private final DataPacketCopyService dataPacketCopyService;

    public DataPacketCopyController(DataPacketCopyService dataPacketCopyService) {
        this.dataPacketCopyService = dataPacketCopyService;
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e\u5305")
    @PostMapping
    @WrapUpResponseBody
    public DataPacketCopy createDataPacket(@RequestBody DataPacketCopy dataPacketCopy, HttpServletRequest request) {
        dataPacketCopy.setRecorder(WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        dataPacketCopy.setDataOptDescJson(dataPacketCopy.getDataOptDescJson());
        this.dataPacketCopyService.createDataPacket(dataPacketCopy);
        return dataPacketCopy;
    }

    @ApiOperation(value="\u7f16\u8f91\u6570\u636e\u5305")
    @PutMapping(value={"/{packetId}"})
    @WrapUpResponseBody
    public void updateDataPacket(@PathVariable String packetId, @RequestBody DataPacketCopy dataPacket) {
        dataPacket.setPacketId(packetId);
        dataPacket.setDataOptDescJson(dataPacket.getDataOptDescJson());
        this.dataPacketCopyService.updateDataPacket(dataPacket);
    }

    @ApiOperation(value="\u6570\u636e\u5305\u53d1\u5e03")
    @PutMapping(value={"publish/{packetId}"})
    @WrapUpResponseBody
    public void publishDataPacket(@PathVariable String packetId) {
        DataPacketCopy dataPacketCopy = this.dataPacketCopyService.getDataPacket(packetId);
        this.dataPacketCopyService.updateDataPacket(dataPacketCopy);
        this.dataPacketCopyService.publishDataPacket(dataPacketCopy);
    }

    @ApiOperation(value="\u7f16\u8f91\u6570\u636e\u5305\u6570\u636e\u5904\u7406\u63cf\u8ff0\u4fe1\u606f")
    @PutMapping(value={"/opt/{packetId}"})
    @WrapUpResponseBody
    public void updateDataPacketOpt(@PathVariable String packetId, @RequestBody String dataOptDescJson) {
        this.dataPacketCopyService.updateDataPacketOptJson(packetId, dataOptDescJson);
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e\u5305")
    @DeleteMapping(value={"/{packetId}"})
    @WrapUpResponseBody
    public void deleteDataPacket(@PathVariable String packetId) {
        this.dataPacketCopyService.deleteDataPacket(packetId);
    }

    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u5305")
    @GetMapping
    @WrapUpResponseBody
    public PageQueryResult<DataPacketCopy> listDataPacket(HttpServletRequest request, PageDesc pageDesc) {
        List list = this.dataPacketCopyService.listDataPacket(BaseController.collectRequestParameters((HttpServletRequest)request), pageDesc);
        return PageQueryResult.createResult((Collection)list, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u6570\u636e\u5305")
    @GetMapping(value={"/{packetId}"})
    @WrapUpResponseBody
    public DataPacketCopy getDataPacket(@PathVariable String packetId) {
        return this.dataPacketCopyService.getDataPacket(packetId);
    }
}

