/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.bizopt;

import com.alibaba.fastjson2.JSONObject;
import com.centit.dde.bizopt.BuiltInOperation;
import com.centit.dde.consumer.KafkaConsumerConfig;
import com.centit.dde.core.BizModel;
import com.centit.dde.core.BizOperation;
import com.centit.dde.core.DataOptContext;
import com.centit.dde.core.DataSet;
import com.centit.framework.common.ResponseData;
import com.centit.product.metadata.po.SourceInfo;
import com.centit.product.metadata.service.SourceInfoMetadata;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;

public class ConsumerBizOperation
implements BizOperation {
    private SourceInfoMetadata sourceInfoMetadata;

    public ConsumerBizOperation(SourceInfoMetadata sourceInfoMetadata) {
        this.sourceInfoMetadata = sourceInfoMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseData runOpt(BizModel bizModel, JSONObject bizOptJson, DataOptContext dataOptContext) throws Exception {
        String databaseId = bizOptJson.getString("databaseId");
        String topic = bizOptJson.getString("topic");
        if (StringUtils.isBlank((CharSequence)topic) || StringUtils.isBlank((CharSequence)databaseId)) {
            return ResponseData.makeErrorMessage((String)"Kafka\u670d\u52a1\u5730\u5740\u6216topic\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SourceInfo sourceInfo = this.sourceInfoMetadata.fetchSourceInfo(databaseId);
        if (sourceInfo == null) {
            return ResponseData.makeErrorMessage((String)"Kafka\u670d\u52a1\u8d44\u6e90\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
        }
        String groupId = bizOptJson.getString("groupId");
        if (StringUtils.isBlank((CharSequence)groupId)) {
            return ResponseData.makeErrorMessage((String)"\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        JSONObject extProps = sourceInfo.getExtProps();
        if (extProps == null) {
            extProps = new JSONObject();
        }
        extProps.put((Object)"group.id", (Object)groupId);
        ArrayList<Object> values = new ArrayList<Object>();
        try (KafkaConsumer consumer = KafkaConsumerConfig.getKafkaConsumer(extProps, sourceInfo);){
            ArrayList<String> objects = new ArrayList<String>();
            objects.add(topic);
            consumer.subscribe(objects);
            ConsumerRecords records = consumer.poll(1000L);
            for (ConsumerRecord record : records) {
                values.add(record.value());
            }
            consumer.commitSync();
        }
        String id = bizOptJson.getString("id");
        bizModel.putDataSet(id, new DataSet(values));
        return BuiltInOperation.createResponseSuccessData((int)values.size());
    }
}

