/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.dao.json;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.centit.dde.adapter.dao.DataPacketDao;
import com.centit.dde.adapter.po.DataPacket;
import com.centit.dde.adapter.po.DataPacketParam;
import com.centit.support.common.CachedMap;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository(value="dataPacketDao")
public class DataPacketDaoImpl
implements DataPacketDao {
    @Value(value="${app.home:./}")
    private String appHome;
    private CachedMap<String, DataPacket> dataPacketCache = new CachedMap(packetId -> this.loadDataPacket((String)packetId), 86400L);

    private DataPacket loadDataPacket(String packetId) {
        String apiFile = this.appHome + File.separator + "config" + File.separator + "apis" + File.separator + packetId + ".json";
        try {
            JSONObject apiJson = JSON.parseObject((InputStream)new FileInputStream(apiFile), (JSONReader.Feature[])new JSONReader.Feature[0]);
            DataPacket packet = (DataPacket)apiJson.toJavaObject(DataPacket.class, new JSONReader.Feature[0]);
            JSONArray params = apiJson.getJSONArray("params");
            if (params != null) {
                packet.setPacketParams(params.toJavaList(DataPacketParam.class, new JSONReader.Feature[0]));
            }
            return packet;
        }
        catch (IOException e) {
            return null;
        }
    }

    public DataPacket getObjectById(Object packetId) {
        return (DataPacket)this.dataPacketCache.getCachedValue((Object)((String)packetId));
    }

    public DataPacket getObjectWithReferences(Object packetId) {
        return (DataPacket)this.dataPacketCache.getCachedValue((Object)((String)packetId));
    }

    public List<DataPacket> listObjectsByProperties(Map<String, Object> params, PageDesc pageDesc) {
        throw new ObjectException(613, "\u8be5\u65b9\u6cd5\u5728\u5f53\u524d\u7248\u672c\u4e0b\u6ca1\u6709\u5b9e\u73b0\uff0c\u8bf7\u8054\u7cfb\u7814\u53d1\u4eba\u5458!");
    }

    public List<DataPacket> listObjectsByProperties(Map<String, Object> params) {
        throw new ObjectException(613, "\u8be5\u65b9\u6cd5\u5728\u5f53\u524d\u7248\u672c\u4e0b\u6ca1\u6709\u5b9e\u73b0\uff0c\u8bf7\u8054\u7cfb\u7814\u53d1\u4eba\u5458!");
    }

    public void saveNewObject(DataPacket dataPacket) {
        throw new ObjectException(613, "\u8be5\u65b9\u6cd5\u5728\u5f53\u524d\u7248\u672c\u4e0b\u6ca1\u6709\u5b9e\u73b0\uff0c\u8bf7\u8054\u7cfb\u7814\u53d1\u4eba\u5458!");
    }

    public int saveObjectReferences(DataPacket dataPacket) {
        throw new ObjectException(613, "\u8be5\u65b9\u6cd5\u5728\u5f53\u524d\u7248\u672c\u4e0b\u6ca1\u6709\u5b9e\u73b0\uff0c\u8bf7\u8054\u7cfb\u7814\u53d1\u4eba\u5458!");
    }

    public int mergeObject(DataPacket dataPacket) {
        throw new ObjectException(613, "\u8be5\u65b9\u6cd5\u5728\u5f53\u524d\u7248\u672c\u4e0b\u6ca1\u6709\u5b9e\u73b0\uff0c\u8bf7\u8054\u7cfb\u7814\u53d1\u4eba\u5458!");
    }

    public int updateObject(String[] fields, DataPacket dataPacket) {
        throw new ObjectException(613, "\u8be5\u65b9\u6cd5\u5728\u5f53\u524d\u7248\u672c\u4e0b\u6ca1\u6709\u5b9e\u73b0\uff0c\u8bf7\u8054\u7cfb\u7814\u53d1\u4eba\u5458!");
    }

    public int deleteObjectReferences(DataPacket dataPacket) {
        throw new ObjectException(613, "\u8be5\u65b9\u6cd5\u5728\u5f53\u524d\u7248\u672c\u4e0b\u6ca1\u6709\u5b9e\u73b0\uff0c\u8bf7\u8054\u7cfb\u7814\u53d1\u4eba\u5458!");
    }

    public int deleteObjectById(Object dataPacket) {
        throw new ObjectException(613, "\u8be5\u65b9\u6cd5\u5728\u5f53\u524d\u7248\u672c\u4e0b\u6ca1\u6709\u5b9e\u73b0\uff0c\u8bf7\u8054\u7cfb\u7814\u53d1\u4eba\u5458!");
    }

    public void publishDataPacket(DataPacket dataPacket) {
        throw new ObjectException(613, "\u8be5\u65b9\u6cd5\u5728\u5f53\u524d\u7248\u672c\u4e0b\u6ca1\u6709\u5b9e\u73b0\uff0c\u8bf7\u8054\u7cfb\u7814\u53d1\u4eba\u5458!");
    }

    public void updateDataPacketOptJson(String packetId, String dataPacketOptJson) {
        throw new ObjectException(613, "\u8be5\u65b9\u6cd5\u5728\u5f53\u524d\u7248\u672c\u4e0b\u6ca1\u6709\u5b9e\u73b0\uff0c\u8bf7\u8054\u7cfb\u7814\u53d1\u4eba\u5458!");
    }

    public int[] batchUpdateOptIdByApiId(String optId, List<String> apiIds) {
        throw new ObjectException(613, "\u8be5\u65b9\u6cd5\u5728\u5f53\u524d\u7248\u672c\u4e0b\u6ca1\u6709\u5b9e\u73b0\uff0c\u8bf7\u8054\u7cfb\u7814\u53d1\u4eba\u5458!");
    }

    public void updateDisableStatus(String packetId, String disable) {
        throw new ObjectException(613, "\u8be5\u65b9\u6cd5\u5728\u5f53\u524d\u7248\u672c\u4e0b\u6ca1\u6709\u5b9e\u73b0\uff0c\u8bf7\u8054\u7cfb\u7814\u53d1\u4eba\u5458!");
    }

    public void batchDeleteByPacketIds(String[] packetIds) {
        throw new ObjectException(613, "\u8be5\u65b9\u6cd5\u5728\u5f53\u524d\u7248\u672c\u4e0b\u6ca1\u6709\u5b9e\u73b0\uff0c\u8bf7\u8054\u7cfb\u7814\u53d1\u4eba\u5458!");
    }

    public void updatePackedLogLevel(int logLevel, List<String> packetIds) {
        throw new ObjectException(613, "\u8be5\u65b9\u6cd5\u5728\u5f53\u524d\u7248\u672c\u4e0b\u6ca1\u6709\u5b9e\u73b0\uff0c\u8bf7\u8054\u7cfb\u7814\u53d1\u4eba\u5458!");
    }

    public void updateApplicationLogLevel(int logLevel, String osId) {
        throw new ObjectException(613, "\u8be5\u65b9\u6cd5\u5728\u5f53\u524d\u7248\u672c\u4e0b\u6ca1\u6709\u5b9e\u73b0\uff0c\u8bf7\u8054\u7cfb\u7814\u53d1\u4eba\u5458!");
    }

    public int clearTrashStand(String osId) {
        throw new ObjectException(613, "\u8be5\u65b9\u6cd5\u5728\u5f53\u524d\u7248\u672c\u4e0b\u6ca1\u6709\u5b9e\u73b0\uff0c\u8bf7\u8054\u7cfb\u7814\u53d1\u4eba\u5458!");
    }
}

