/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde;

import com.alibaba.fastjson.JSONObject;
import com.centit.dde.bizopt.BuiltInOperation;
import com.centit.dde.core.BizModel;
import com.centit.dde.core.BizOperation;
import com.centit.dde.core.DataOptContext;
import com.centit.dde.core.DataSet;
import com.centit.dde.utils.BizModelJSONTransform;
import com.centit.dde.utils.DataRowVariableTranslate;
import com.centit.dde.utils.DataSetOptUtil;
import com.centit.framework.common.ResponseData;
import com.centit.search.document.ESDocument;
import com.centit.search.document.FileDocument;
import com.centit.search.document.ObjectDocument;
import com.centit.search.service.ESServerConfig;
import com.centit.search.service.Impl.ESIndexer;
import com.centit.search.service.IndexerSearcherFactory;
import com.centit.search.utils.TikaTextExtractor;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.compiler.VariableFormula;
import com.centit.support.compiler.VariableTranslate;
import com.centit.support.json.JSONTransformDataSupport;
import com.centit.support.json.JSONTransformer;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class EsWriteBizOperation
implements BizOperation {
    private final ESServerConfig esServerConfig;

    public EsWriteBizOperation(ESServerConfig esServerConfig) {
        this.esServerConfig = esServerConfig;
    }

    public ResponseData runOpt(BizModel bizModel, JSONObject bizOptJson, DataOptContext dataOptContext) throws Exception {
        String operationType = bizOptJson.getString("operationType");
        if (StringUtils.isBlank((CharSequence)operationType)) {
            return ResponseData.makeErrorMessage((String)"\u8bf7\u9009\u62e9\u64cd\u4f5c\u7c7b\u578b\uff01");
        }
        boolean indexFile = "indexFile".equals(bizOptJson.get((Object)"indexType"));
        ESIndexer esIndexer = indexFile ? IndexerSearcherFactory.obtainIndexer((ESServerConfig)this.esServerConfig, FileDocument.class) : IndexerSearcherFactory.obtainIndexer((ESServerConfig)this.esServerConfig, ObjectDocument.class);
        return indexFile ? this.fileDocumentOperation(bizModel, bizOptJson, dataOptContext, esIndexer, operationType) : this.objectDocumentOperation(bizModel, bizOptJson, dataOptContext, esIndexer, operationType);
    }

    private ResponseData fileDocumentOperation(BizModel bizModel, JSONObject bizOptJson, DataOptContext dataOptContext, ESIndexer esIndexer, String operationType) throws Exception {
        Object result;
        BizModelJSONTransform transform = new BizModelJSONTransform(bizModel);
        String documentId = StringBaseOpt.castObjectToString((Object)transform.attainExpressionValue(bizOptJson.getString("documentId")));
        if (StringUtils.isBlank((CharSequence)documentId)) {
            return ResponseData.makeErrorMessage((String)"\u6587\u6863\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!"delete".equals(operationType)) {
            String dataSetId = bizOptJson.getString("source");
            if (StringUtils.isBlank((CharSequence)dataSetId)) {
                return ResponseData.makeErrorMessage((String)"\u6587\u6863\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            DataSet dataSet = bizModel.getDataSet(dataSetId);
            if (dataSet == null) {
                return ResponseData.makeErrorMessage((String)"\u9009\u62e9\u7684\u6587\u6863\u5185\u5bb9\u4e0d\u5b58\u5728\uff01");
            }
            Object optTag = transform.attainExpressionValue(bizOptJson.getString("optTag"));
            if (optTag == null) {
                return ResponseData.makeErrorMessage((String)"\u4e1a\u52a1\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        switch (operationType) {
            case "add": {
                result = esIndexer.saveNewDocument((ESDocument)this.fileDocumentBuild(bizModel, bizOptJson, dataOptContext, transform));
                break;
            }
            case "delete": {
                result = esIndexer.deleteDocument(documentId);
                break;
            }
            case "update": {
                result = esIndexer.updateDocument((ESDocument)this.fileDocumentBuild(bizModel, bizOptJson, dataOptContext, transform));
                break;
            }
            default: {
                result = esIndexer.mergeDocument((ESDocument)this.fileDocumentBuild(bizModel, bizOptJson, dataOptContext, transform));
            }
        }
        return ResponseData.makeResponseData((Object)result);
    }

    private FileDocument fileDocumentBuild(BizModel bizModel, JSONObject bizOptJson, DataOptContext dataOptContext, BizModelJSONTransform modelTrasform) throws Exception {
        DataSet dataSet = bizModel.getDataSet(bizOptJson.getString("source"));
        FileDocument fileInfo = new FileDocument();
        fileInfo.setOptId(dataOptContext.getOptId());
        fileInfo.setOsId(dataOptContext.getOsId());
        fileInfo.setOptMethod("index");
        fileInfo.setUserCode(dataOptContext.getCurrentUserCode());
        fileInfo.setUnitCode(dataOptContext.getCurrentUnitCode());
        fileInfo.setContent(TikaTextExtractor.extractInputStreamText((InputStream)DataSetOptUtil.getInputStreamFormFile((Map)dataSet.getFirstRow())));
        fileInfo.setFileId(StringBaseOpt.castObjectToString((Object)modelTrasform.attainExpressionValue(bizOptJson.getString("documentId"))));
        fileInfo.setFileName(StringBaseOpt.castObjectToString((Object)modelTrasform.attainExpressionValue(bizOptJson.getString("fileName"))));
        fileInfo.setFileSummary(StringBaseOpt.castObjectToString((Object)modelTrasform.attainExpressionValue(bizOptJson.getString("fileSummary"))));
        fileInfo.setFileMD5(StringBaseOpt.castObjectToString((Object)modelTrasform.attainExpressionValue(bizOptJson.getString("fileMD5"))));
        fileInfo.setOptTag(StringBaseOpt.castObjectToString((Object)modelTrasform.attainExpressionValue(bizOptJson.getString("optTag"))));
        fileInfo.setCreateTime(new Date());
        Object keywords = modelTrasform.attainExpressionValue(bizOptJson.getString("keywords"));
        if (keywords != null) {
            fileInfo.setKeywords(StringBaseOpt.castObjectToString((Object)keywords).split(" "));
        }
        return fileInfo;
    }

    private ResponseData objectDocumentOperation(BizModel bizModel, JSONObject bizOptJson, DataOptContext dataOptContext, ESIndexer esIndexer, String operationType) {
        String dataSetId = bizOptJson.getString("source");
        if (StringUtils.isBlank((CharSequence)dataSetId)) {
            return ResponseData.makeErrorMessage((String)"\u53c2\u6570\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        DataSet dataSet = bizModel.getDataSet(dataSetId);
        if (dataSet == null) {
            return ResponseData.makeErrorMessage((String)"\u9009\u62e9\u7684\u53c2\u6570\u6765\u6e90\u4e0d\u5b58\u5728\uff01");
        }
        String optTag = bizOptJson.getString("optTag");
        if (StringUtils.isBlank((CharSequence)optTag)) {
            return ResponseData.makeErrorMessage((String)"\u4e1a\u52a1\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if ("delete".equals(operationType)) {
            Object documentId = JSONTransformer.transformer((Object)BuiltInOperation.getJsonFieldString((JSONObject)bizOptJson, (String)"documentId", null), (JSONTransformDataSupport)new BizModelJSONTransform(bizModel));
            if (documentId == null) {
                return ResponseData.makeErrorMessage((String)"\u6587\u6863\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            boolean b = esIndexer.deleteDocument(StringBaseOpt.castObjectToString((Object)documentId));
            return ResponseData.makeResponseData((Object)b);
        }
        VariableFormula formula = new VariableFormula();
        List dataAsList = dataSet.getDataAsList();
        int rowInd = 0;
        int rowCount = dataAsList.size();
        ArrayList<Object> addResult = new ArrayList<Object>();
        block8: for (Map documentInfo : dataAsList) {
            formula.setTrans((VariableTranslate)new DataRowVariableTranslate((Object)documentInfo, rowInd++, rowCount));
            switch (operationType) {
                case "add": {
                    addResult.add(esIndexer.saveNewDocument((ESDocument)this.objectDocumentBuild(formula, documentInfo, bizOptJson, dataOptContext)));
                    continue block8;
                }
                case "update": {
                    addResult.add(esIndexer.updateDocument((ESDocument)this.objectDocumentBuild(formula, documentInfo, bizOptJson, dataOptContext)));
                    continue block8;
                }
            }
            addResult.add(esIndexer.mergeDocument((ESDocument)this.objectDocumentBuild(formula, documentInfo, bizOptJson, dataOptContext)));
        }
        return ResponseData.makeResponseData(addResult);
    }

    private ObjectDocument objectDocumentBuild(VariableFormula formula, Map<String, Object> documentInfo, JSONObject bizOptJson, DataOptContext dataOptContext) {
        ObjectDocument objInfo = new ObjectDocument();
        objInfo.setOptId(dataOptContext.getOptId());
        objInfo.setOsId(dataOptContext.getOsId());
        objInfo.setOptMethod("index");
        objInfo.setUserCode(dataOptContext.getCurrentUserCode());
        objInfo.setUnitCode(dataOptContext.getCurrentUnitCode());
        objInfo.setOptTag(StringBaseOpt.castObjectToString((Object)formula.calcFormula(bizOptJson.getString("optTag"))));
        objInfo.contentObject(documentInfo);
        Object title = formula.calcFormula(bizOptJson.getString("title"));
        objInfo.setTitle(StringBaseOpt.castObjectToString((Object)title));
        objInfo.setCreateTime(new Date());
        return objInfo;
    }
}

