/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde;

import com.centit.dde.EsQueryBizOperation;
import com.centit.dde.EsWriteBizOperation;
import com.centit.dde.core.BizOperation;
import com.centit.dde.core.BizOptFlow;
import com.centit.search.service.ESServerConfig;
import com.centit.support.algorithm.NumberBaseOpt;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class EsRegisterOperation {
    @Resource
    BizOptFlow bizOptFlow;
    @Autowired
    Environment env;

    @PostConstruct
    void registerOperation() {
        ESServerConfig esServerConfig = this.esServerConfig();
        this.bizOptFlow.registerOperation("esQuery", (BizOperation)new EsQueryBizOperation(esServerConfig));
        this.bizOptFlow.registerOperation("esWrite", (BizOperation)new EsWriteBizOperation(esServerConfig));
    }

    private ESServerConfig esServerConfig() {
        ESServerConfig config = new ESServerConfig();
        config.setServerHostIp(this.env.getProperty("elasticsearch.server.ip"));
        config.setServerHostPort(this.env.getProperty("elasticsearch.server.port"));
        config.setClusterName(this.env.getProperty("elasticsearch.server.cluster"));
        config.setOsId(this.env.getProperty("elasticsearch.osId"));
        config.setUsername(this.env.getProperty("elasticsearch.server.username"));
        config.setPassword(this.env.getProperty("elasticsearch.server.password"));
        config.setMinScore(NumberBaseOpt.parseFloat((String)this.env.getProperty("elasticsearch.filter.minScore"), (Float)Float.valueOf(0.5f)).floatValue());
        return config;
    }
}

