/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde;

import com.alibaba.fastjson.JSONObject;
import com.centit.dde.bizopt.BuiltInOperation;
import com.centit.dde.core.BizModel;
import com.centit.dde.core.BizOperation;
import com.centit.dde.core.DataOptContext;
import com.centit.dde.core.DataSet;
import com.centit.dde.utils.BizModelJSONTransform;
import com.centit.framework.common.ResponseData;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.search.document.FileDocument;
import com.centit.search.document.ObjectDocument;
import com.centit.search.service.ESServerConfig;
import com.centit.search.service.Impl.ESSearcher;
import com.centit.search.service.IndexerSearcherFactory;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.PageDesc;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class EsQueryBizOperation
implements BizOperation {
    private final ESServerConfig esServerConfig;

    public EsQueryBizOperation(ESServerConfig esServerConfig) {
        this.esServerConfig = esServerConfig;
    }

    public ResponseData runOpt(BizModel bizModel, JSONObject bizOptJson, DataOptContext dataOptContext) {
        HashMap<String, Object> queryParam = new HashMap<String, Object>(6);
        queryParam.put("osId", dataOptContext.getOsId());
        BizModelJSONTransform transform = new BizModelJSONTransform(bizModel);
        if (!bizOptJson.getBoolean("queryAll").booleanValue()) {
            Object optTag = transform.attainExpressionValue(bizOptJson.getString("optTag"));
            Object unitCode = transform.attainExpressionValue(bizOptJson.getString("unitCode"));
            Object userCode = transform.attainExpressionValue(bizOptJson.getString("userCode"));
            if (optTag != null) {
                queryParam.put("optTag", optTag);
            }
            if (unitCode != null) {
                queryParam.put("unitCode", unitCode);
            }
            if (userCode != null) {
                queryParam.put("userCode", userCode);
            }
        }
        int pageNo = NumberBaseOpt.castObjectToInteger((Object)transform.attainExpressionValue(bizOptJson.getString("pageNo")), (Integer)1);
        int pageSize = NumberBaseOpt.castObjectToInteger((Object)transform.attainExpressionValue(bizOptJson.getString("pageSize")), (Integer)20);
        boolean indexFile = "indexFile".equals(bizOptJson.get((Object)"indexType"));
        ESSearcher esSearcher = indexFile ? IndexerSearcherFactory.obtainSearcher((ESServerConfig)this.esServerConfig, FileDocument.class) : IndexerSearcherFactory.obtainSearcher((ESServerConfig)this.esServerConfig, ObjectDocument.class);
        String keyword = StringBaseOpt.castObjectToString((Object)transform.attainExpressionValue(bizOptJson.getString("queryParameter")));
        if (StringUtils.isBlank((CharSequence)keyword)) {
            return ResponseData.makeErrorMessage((String)"\u67e5\u8be2\u5173\u952e\u5b57\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryBuilder queryBuilder = this.queryBuilder(queryParam, keyword, indexFile, esSearcher, bizOptJson, transform);
        String[] excludes = null;
        if (!bizOptJson.getBoolean("returnAllField").booleanValue()) {
            excludes = new String[]{"content"};
        }
        Pair search = esSearcher.esSearch(queryBuilder, null, excludes, pageNo, pageSize);
        PageDesc pageDesc = new PageDesc();
        pageDesc.setPageNo(pageNo);
        pageDesc.setPageSize(pageSize);
        pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)search.getLeft()));
        PageQueryResult result = PageQueryResult.createResult((Collection)((Collection)search.getRight()), (PageDesc)pageDesc);
        DataSet dataSet = new DataSet((Object)result);
        bizModel.putDataSet(bizOptJson.getString("id"), dataSet);
        return BuiltInOperation.createResponseSuccessData((int)dataSet.getSize());
    }

    private QueryBuilder queryBuilder(Map<String, Object> queryParam, String keyword, Boolean indexFile, ESSearcher esSearcher, JSONObject bizOptJson, BizModelJSONTransform transform) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (queryParam != null) {
            for (Map.Entry<String, Object> entry : queryParam.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (StringUtils.isBlank((CharSequence)key) || value == null) continue;
                if (value.getClass().isArray()) {
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)key, (String[])((String[])value)));
                    continue;
                }
                if (value instanceof Collection) {
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)key, (Object[])CollectionsOpt.listToArray((Collection)((Collection)value))));
                    continue;
                }
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)value));
            }
        }
        esSearcher.initTypeFields(indexFile != false ? FileDocument.class : ObjectDocument.class);
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            MultiMatchQueryBuilder multiMatchQueryBuilder = QueryBuilders.multiMatchQuery((Object)keyword, (String[])esSearcher.getQueryFields());
            Boolean custom = bizOptJson.getBoolean("custom");
            if (custom.booleanValue()) {
                String analyzer = StringBaseOpt.castObjectToString((Object)transform.attainExpressionValue(bizOptJson.getString("analyzer")));
                String minimumShouldMatch = StringBaseOpt.castObjectToString((Object)transform.attainExpressionValue(bizOptJson.getString("minimumShouldMatch")));
                if (StringUtils.isNotBlank((CharSequence)analyzer)) {
                    multiMatchQueryBuilder.analyzer(analyzer);
                }
                if (StringUtils.isNotBlank((CharSequence)minimumShouldMatch)) {
                    multiMatchQueryBuilder.minimumShouldMatch(minimumShouldMatch);
                }
            }
            boolQueryBuilder.must((QueryBuilder)multiMatchQueryBuilder);
        }
        return boolQueryBuilder;
    }
}

