/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.bizopt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.dde.bizopt.BuiltInOperation;
import com.centit.dde.core.BizModel;
import com.centit.dde.core.BizOperation;
import com.centit.dde.core.DataOptContext;
import com.centit.dde.core.DataSet;
import com.centit.dde.utils.DataSetOptUtil;
import com.centit.framework.common.ResponseData;
import com.centit.search.document.ESDocument;
import com.centit.search.document.FileDocument;
import com.centit.search.document.ObjectDocument;
import com.centit.search.service.ESServerConfig;
import com.centit.search.service.Impl.ESIndexer;
import com.centit.search.service.IndexerSearcherFactory;
import com.centit.support.algorithm.StringBaseOpt;
import java.util.List;
import java.util.Map;

public class EsWriteBizOperation
implements BizOperation {
    private ESServerConfig esServerConfig;

    public EsWriteBizOperation(ESServerConfig esServerConfig) {
        this.esServerConfig = esServerConfig;
    }

    public ResponseData runOpt(BizModel bizModel, JSONObject bizOptJson, DataOptContext dataOptContext) throws Exception {
        ObjectDocument esDocument;
        ESIndexer esIndexer;
        String indexType = bizOptJson.getString("indexType");
        if (StringBaseOpt.isNvl((String)indexType)) {
            return ResponseData.makeErrorMessage((String)"\u8bf7\u9009\u62e9\u5199\u5165\u7684\u7d22\u5f15\u7c7b\u578b\uff01");
        }
        String dataSetId = bizOptJson.getString("source");
        if (StringBaseOpt.isNvl((String)dataSetId)) {
            return ResponseData.makeErrorMessage((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5199\u5165\u7684\u6570\u636e\uff01");
        }
        DataSet dataSet = bizModel.getDataSet(dataSetId);
        if (dataSet == null) {
            return ResponseData.makeErrorMessage((String)"\u9009\u62e9\u7684\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff01");
        }
        switch (indexType) {
            case "indexObject": {
                esIndexer = IndexerSearcherFactory.obtainIndexer((ESServerConfig)this.esServerConfig, ObjectDocument.class);
                esDocument = new ObjectDocument();
                break;
            }
            case "indexFile": {
                esIndexer = IndexerSearcherFactory.obtainIndexer((ESServerConfig)this.esServerConfig, FileDocument.class);
                esDocument = new FileDocument();
                break;
            }
            default: {
                return ResponseData.makeErrorMessage((String)"\u672a\u77e5\u7d22\u5f15\u7c7b\u578b\uff01");
            }
        }
        List dataAsList = dataSet.getDataAsList();
        Map mapInfo = BuiltInOperation.jsonArrayToMap((JSONArray)bizOptJson.getJSONArray("config"), (String)"columnName", (String[])new String[]{"expression"});
        dataAsList.stream().forEach(arg_0 -> EsWriteBizOperation.lambda$runOpt$0(mapInfo, (ESDocument)esDocument, esIndexer, arg_0));
        return BuiltInOperation.createResponseSuccessData((int)dataAsList.size());
    }

    private static /* synthetic */ void lambda$runOpt$0(Map mapInfo, ESDocument esDocument, ESIndexer esIndexer, Map documentInfo) {
        DataSet destDs = DataSetOptUtil.mapDateSetByFormula((DataSet)new DataSet((Object)documentInfo), mapInfo.entrySet());
        if (destDs != null) {
            String eSDocumentInfo = StringBaseOpt.castObjectToString((Object)destDs.getFirstRow());
            ESDocument esDocumentInfo = (ESDocument)JSONObject.parseObject((String)eSDocumentInfo, esDocument.getClass());
            esIndexer.mergeDocument(esDocumentInfo);
        }
    }
}

