/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.bizopt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.dde.bizopt.BuiltInOperation;
import com.centit.dde.core.BizModel;
import com.centit.dde.core.BizOperation;
import com.centit.dde.core.DataOptContext;
import com.centit.dde.core.DataSet;
import com.centit.dde.utils.BizModelJSONTransform;
import com.centit.framework.common.ResponseData;
import com.centit.search.document.FileDocument;
import com.centit.search.document.ObjectDocument;
import com.centit.search.service.ESServerConfig;
import com.centit.search.service.Impl.ESSearcher;
import com.centit.search.service.IndexerSearcherFactory;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.json.JSONTransformDataSupport;
import com.centit.support.json.JSONTransformer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class EsQueryBizOperation
implements BizOperation {
    private ESServerConfig esServerConfig;

    public EsQueryBizOperation(ESServerConfig esServerConfig) {
        this.esServerConfig = esServerConfig;
    }

    public ResponseData runOpt(BizModel bizModel, JSONObject bizOptJson, DataOptContext dataOptContext) {
        ESSearcher esSearcher;
        String indexType = bizOptJson.getString("indexType");
        if (StringBaseOpt.isNvl((String)indexType)) {
            return ResponseData.makeErrorMessage((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u7684\u7d22\u5f15\u7c7b\u578b\uff01");
        }
        String queryParameter = bizOptJson.getString("queryParameter");
        if (StringBaseOpt.isNvl((String)queryParameter)) {
            return ResponseData.makeErrorMessage((String)"\u67e5\u8be2\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        JSONArray fieldAttributeInfos = bizOptJson.getJSONArray("fieldAttributeInfos");
        HashMap queryParam = new HashMap();
        fieldAttributeInfos.stream().forEach(fieldAttributeInfo -> {
            Map fieldInfo = CollectionsOpt.objectToMap((Object)fieldAttributeInfo);
            String fieldName = StringBaseOpt.castObjectToString(fieldInfo.get("fieldName"));
            Object fieldValue = JSONTransformer.transformer(fieldInfo.get("value"), (JSONTransformDataSupport)new BizModelJSONTransform(bizModel));
            if (!StringBaseOpt.isNvl((String)fieldName) && fieldValue != null) {
                queryParam.put(fieldName, fieldValue);
            }
        });
        switch (indexType) {
            case "indexObject": {
                esSearcher = IndexerSearcherFactory.obtainSearcher((ESServerConfig)this.esServerConfig, ObjectDocument.class);
                break;
            }
            case "indexFile": {
                esSearcher = IndexerSearcherFactory.obtainSearcher((ESServerConfig)this.esServerConfig, FileDocument.class);
                break;
            }
            default: {
                return ResponseData.makeErrorMessage((String)"\u672a\u77e5\u7d22\u5f15\u7c7b\u578b\uff01");
            }
        }
        int pageNo = NumberBaseOpt.castObjectToInteger(queryParam.get("pageNo"), (Integer)1);
        int pageSize = NumberBaseOpt.castObjectToInteger(queryParam.get("pageSize"), (Integer)20);
        Pair search = esSearcher.search(queryParam, queryParameter, pageNo, pageSize);
        DataSet dataSet = new DataSet(search.getValue());
        bizModel.putDataSet(bizOptJson.getString("id"), dataSet);
        return BuiltInOperation.createResponseSuccessData((int)dataSet.getSize());
    }
}

