/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde;

import com.centit.dde.bizopt.EsQueryBizOperation;
import com.centit.dde.bizopt.EsWriteBizOperation;
import com.centit.dde.core.BizOperation;
import com.centit.dde.core.BizOptFlow;
import com.centit.search.service.ESServerConfig;
import com.centit.support.algorithm.NumberBaseOpt;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class EsRegisterOperation {
    @Resource
    BizOptFlow bizOptFlow;
    @Autowired
    Environment environment;

    @PostConstruct
    void registerOperation() {
        ESServerConfig esServerConfig = this.esServerConfig();
        this.bizOptFlow.registerOperation("esQuery", (BizOperation)new EsQueryBizOperation(esServerConfig));
        this.bizOptFlow.registerOperation("esWrite", (BizOperation)new EsWriteBizOperation(esServerConfig));
    }

    private ESServerConfig esServerConfig() {
        ESServerConfig config = new ESServerConfig();
        config.setServerHostIp(this.environment.getProperty("elasticsearch.server.ip"));
        config.setServerHostPort(this.environment.getProperty("elasticsearch.server.port"));
        config.setClusterName(this.environment.getProperty("elasticsearch.server.cluster"));
        config.setOsId(this.environment.getProperty("elasticsearch.osId"));
        config.setMinScore(NumberBaseOpt.parseFloat((String)this.environment.getProperty("elasticsearch.filter.minScore"), (Float)Float.valueOf(0.5f)).floatValue());
        return config;
    }
}

