package com.centit.dde.bizopt;

import com.alibaba.fastjson.JSONObject;
import com.centit.dde.config.ElasticSearchConfig;
import com.centit.dde.core.BizModel;
import com.centit.dde.core.BizOperation;
import com.centit.dde.core.DataSet;
import com.centit.dde.core.SimpleDataSet;
import com.centit.dde.entity.EsWriteVo;
import com.centit.dde.factory.PooledRestClientFactory;
import com.centit.dde.write.ElasticsearchWriteUtils;
import com.centit.dde.utils.EsIndexNameExistsUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseSingleData;
import com.centit.product.adapter.po.SourceInfo;
import com.centit.product.metadata.dao.SourceInfoDao;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.elasticsearch.client.RestHighLevelClient;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EsWriteBizOperation implements BizOperation {
    public static final Log log = LogFactory.getLog(EsWriteBizOperation.class);

    private SourceInfoDao sourceInfoDao;

    public EsWriteBizOperation( ) {
    }

    public EsWriteBizOperation(SourceInfoDao sourceInfoDao) {
        this.sourceInfoDao = sourceInfoDao;
    }



    @Override
    public ResponseData runOpt(BizModel bizModel, JSONObject bizOptJson) throws Exception {
        return writeEs(bizModel, bizOptJson);
    }

    //ES插入操作
    private ResponseData writeEs(BizModel bizModel, JSONObject bizOptJson) throws Exception {
        EsWriteVo esSearchWriteEntity = JSONObject.parseObject(bizOptJson.toJSONString(), EsWriteVo.class);
        String source = esSearchWriteEntity.getSource();
        DataSet dataSet = bizModel.getDataSet(source);
        List<Map<String, Object>> data = dataSet.getDataAsList();
        List<String> addData = new ArrayList<>();
        for (Map<String, Object> datum : data) {
            String jsonData = JSONObject.toJSONString(datum);
            addData.add(jsonData);
        }
        SourceInfo sourceInfo = sourceInfoDao.getDatabaseInfoById(esSearchWriteEntity.getDataSourceId());
        GenericObjectPool<RestHighLevelClient> restHighLevelClientGenericObjectPool = PooledRestClientFactory.obtainclientPool(new ElasticSearchConfig(), sourceInfo);
        RestHighLevelClient restHighLevelClient=null;
        try {
            restHighLevelClient = restHighLevelClientGenericObjectPool.borrowObject();
            String indexName = esSearchWriteEntity.getIndexName();
            if (!EsIndexNameExistsUtils.indexNameExists(restHighLevelClient,indexName)){
                return BuiltInOperation.getResponseData(0, 500, bizOptJson.getString("SetsName")+":"+indexName+"索引不存在！");
            }
            JSONObject jsonObject = ElasticsearchWriteUtils.batchSaveDocuments(restHighLevelClient,addData, esSearchWriteEntity);
            bizModel.putDataSet(esSearchWriteEntity.getId(),new SimpleDataSet(jsonObject));
            return ResponseSingleData.makeResponseData(jsonObject);
        }finally {
            restHighLevelClientGenericObjectPool.returnObject(restHighLevelClient);
            log.debug("restHighLevelClient放回连接池中");
        }
    }

}
