/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.utils;

import com.alibaba.fastjson.JSONObject;
import com.centit.dde.entity.EsSearchWriteEntity;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchWriteUtils {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchWriteUtils.class);

    public static Boolean batchSaveDocuments(RestHighLevelClient restHighLevelClient, List<String> jsonDatas, EsSearchWriteEntity esSearchWriteEntity) throws IOException {
        BulkRequest requestBulk = new BulkRequest(esSearchWriteEntity.getIndexName());
        for (String jsonData : jsonDatas) {
            String documentid = ElasticsearchWriteUtils.getDocument(jsonData, esSearchWriteEntity.getDocumentIds());
            if (ElasticsearchWriteUtils.documentIdExist(restHighLevelClient, esSearchWriteEntity.getIndexName(), documentid)) {
                UpdateRequest updateRequest = new UpdateRequest(esSearchWriteEntity.getIndexName(), documentid);
                updateRequest.doc(jsonData, XContentType.JSON);
                requestBulk.add(updateRequest);
                continue;
            }
            IndexRequest indexReq = new IndexRequest().source(jsonData, XContentType.JSON);
            indexReq.id(documentid);
            requestBulk.add(indexReq);
        }
        BulkResponse bulkResponse = restHighLevelClient.bulk(requestBulk, RequestOptions.DEFAULT);
        for (BulkItemResponse bulkItemResponse : bulkResponse) {
            DocWriteResponse itemResponse = bulkItemResponse.getResponse();
            IndexResponse indexResponse = (IndexResponse)itemResponse;
            logger.info("\u5355\u6761\u8fd4\u56de\u7ed3\u679c\uff1a" + indexResponse.toString());
            if (!bulkItemResponse.isFailed()) continue;
            logger.error("es \u8fd4\u56de\u9519\u8bef:" + bulkItemResponse.getFailureMessage());
            return false;
        }
        return true;
    }

    private static String getDocument(String jsonData, String fields) {
        StringBuilder doucmentId = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)fields)) {
            String[] fieldArr = fields.split(",");
            JSONObject jsonObject = JSONObject.parseObject((String)jsonData);
            for (int i = 0; i < fieldArr.length; ++i) {
                doucmentId.append(jsonObject.get((Object)fieldArr[i]));
            }
        } else {
            doucmentId.append(UUID.randomUUID().toString().replaceAll("-", ""));
        }
        return doucmentId.toString();
    }

    public static boolean documentIdExist(RestHighLevelClient restHighLevelClient, String indexName, String documentId) throws IOException {
        GetRequest request = new GetRequest(indexName).id(documentId);
        return restHighLevelClient.exists(request, RequestOptions.DEFAULT);
    }
}

