/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.dde.entity.EsSearchWriteEntity;
import com.centit.dde.entity.EsSerachReadEntity;
import com.centit.dde.entity.QueryParameter;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class ElasticsearchUtil {
    public static final Log log = LogFactory.getLog(ElasticsearchUtil.class);

    public static boolean documentIdExist(RestHighLevelClient restHighLevelClient, String indexName, String documentId) throws IOException {
        GetRequest request = new GetRequest(indexName).id(documentId);
        return restHighLevelClient.exists(request, RequestOptions.DEFAULT);
    }

    private static void publicPart(EsSerachReadEntity esSerachReadEntity, SearchSourceBuilder searchSourceBuilder) {
        searchSourceBuilder.fetchSource(esSerachReadEntity.getReturnField(), esSerachReadEntity.getNotReturnField());
        searchSourceBuilder.timeout(new TimeValue(120L, TimeUnit.SECONDS));
        if (esSerachReadEntity.getSortFieldMap() != null && esSerachReadEntity.getSortFieldMap().size() > 0) {
            esSerachReadEntity.getSortFieldMap().forEach((key, value) -> searchSourceBuilder.sort(key, value == "DESC" ? SortOrder.DESC : SortOrder.ASC));
        } else {
            searchSourceBuilder.explain(Boolean.valueOf(true));
        }
        if (esSerachReadEntity.getPageNo() != null && esSerachReadEntity.getPageSize() != null) {
            searchSourceBuilder.from((esSerachReadEntity.getPageNo() - 1) * esSerachReadEntity.getPageSize());
            searchSourceBuilder.size(esSerachReadEntity.getPageSize().intValue());
        }
    }

    private static JSONArray resultPart(SearchResponse searchResponse) {
        JSONArray resultArrays = new JSONArray();
        if (RestStatus.OK.equals((Object)searchResponse.status()) && searchResponse.getHits().getTotalHits().value > 0L) {
            SearchHits hits = searchResponse.getHits();
            for (SearchHit hit : hits) {
                JSONObject jsonObject = JSONObject.parseObject((String)hit.getSourceAsString());
                log.debug((Object)("\u83b7\u53d6es\u6570\u636e:" + jsonObject.toJSONString()));
                resultArrays.add((Object)jsonObject);
            }
        }
        return resultArrays;
    }

    private static String getDocument(String jsonData, String fields) {
        StringBuilder doucmentId = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)fields)) {
            String[] fieldArr = fields.split(",");
            JSONObject jsonObject = JSONObject.parseObject((String)jsonData);
            for (int i = 0; i < fieldArr.length; ++i) {
                doucmentId.append(jsonObject.get((Object)fieldArr[i]));
            }
        } else {
            doucmentId.append(UUID.randomUUID().toString().replaceAll("-", ""));
        }
        return doucmentId.toString();
    }

    public static IndexResponse saveDocument(RestHighLevelClient restHighLevelClient, String jsonData, EsSearchWriteEntity esSearchWriteEntity) {
        IndexRequest request = new IndexRequest(esSearchWriteEntity.getIndexName());
        request = request.id(ElasticsearchUtil.getDocument(jsonData, esSearchWriteEntity.getDocumentIds()));
        request.source(jsonData, XContentType.JSON);
        IndexResponse indexResponse = null;
        try {
            indexResponse = restHighLevelClient.index(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return indexResponse;
    }

    public static Boolean saveDocuments(RestHighLevelClient restHighLevelClient, List<String> jsonDatas, EsSearchWriteEntity esSearchWriteEntity) throws IOException {
        BulkRequest requestBulk = new BulkRequest(esSearchWriteEntity.getIndexName());
        for (String jsonData : jsonDatas) {
            String documentid = ElasticsearchUtil.getDocument(jsonData, esSearchWriteEntity.getDocumentIds());
            if (ElasticsearchUtil.documentIdExist(restHighLevelClient, esSearchWriteEntity.getIndexName(), documentid)) {
                UpdateRequest updateRequest = new UpdateRequest(esSearchWriteEntity.getIndexName(), documentid);
                updateRequest.doc(jsonData, XContentType.JSON);
                requestBulk.add(updateRequest);
                continue;
            }
            IndexRequest indexReq = new IndexRequest().source(jsonData, XContentType.JSON);
            indexReq.id(documentid);
            requestBulk.add(indexReq);
        }
        BulkResponse bulkResponse = restHighLevelClient.bulk(requestBulk, RequestOptions.DEFAULT);
        for (BulkItemResponse bulkItemResponse : bulkResponse) {
            DocWriteResponse itemResponse = bulkItemResponse.getResponse();
            IndexResponse indexResponse = (IndexResponse)itemResponse;
            log.info((Object)("\u5355\u6761\u8fd4\u56de\u7ed3\u679c\uff1a" + indexResponse.toString()));
            if (!bulkItemResponse.isFailed()) continue;
            log.error((Object)("es \u8fd4\u56de\u9519\u8bef:" + bulkItemResponse.getFailureMessage()));
            return false;
        }
        return true;
    }

    public static JSONArray accurateQuery(RestHighLevelClient restHighLevelClient, EsSerachReadEntity esSerachReadEntity) {
        try {
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            ElasticsearchUtil.publicPart(esSerachReadEntity, searchSourceBuilder);
            for (QueryParameter queryParameter : esSerachReadEntity.getQueryFieldMap()) {
                searchSourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)queryParameter.getField(), (String)queryParameter.getValue()).boost(queryParameter.getBoots() == null ? 1.0f : queryParameter.getBoots().floatValue()));
            }
            SearchRequest searchRequest = new SearchRequest(new String[]{esSerachReadEntity.getIndexName()});
            searchRequest.source(searchSourceBuilder);
            SearchResponse searchResponse = restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
            return ElasticsearchUtil.resultPart(searchResponse);
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public static JSONArray matchQuery(RestHighLevelClient restHighLevelClient, EsSerachReadEntity esSerachReadEntity) {
        try {
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            for (QueryParameter queryParameter : esSerachReadEntity.getQueryFieldMap()) {
                searchSourceBuilder.query((QueryBuilder)((MatchQueryBuilder)QueryBuilders.matchQuery((String)queryParameter.getField(), (Object)queryParameter.getValue()).analyzer(queryParameter.getAnalyzer() == null ? null : queryParameter.getAnalyzer()).boost(queryParameter.getBoots() == null ? 1.0f : queryParameter.getBoots().floatValue())).minimumShouldMatch(queryParameter.getQueryMinimumProportion() == null ? null : queryParameter.getQueryMinimumProportion()));
            }
            ElasticsearchUtil.publicPart(esSerachReadEntity, searchSourceBuilder);
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
            SearchRequest searchRequest = new SearchRequest(new String[]{esSerachReadEntity.getIndexName()});
            searchRequest.source(searchSourceBuilder);
            SearchResponse searchResponse = restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
            return ElasticsearchUtil.resultPart(searchResponse);
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public static JSONArray matchAllQuery(RestHighLevelClient restHighLevelClient, EsSerachReadEntity esSerachReadEntity) {
        try {
            MatchAllQueryBuilder matchAllQueryBuilder = QueryBuilders.matchAllQuery();
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            ElasticsearchUtil.publicPart(esSerachReadEntity, searchSourceBuilder);
            searchSourceBuilder.query((QueryBuilder)matchAllQueryBuilder);
            SearchRequest searchRequest = new SearchRequest(new String[]{esSerachReadEntity.getIndexName()});
            searchRequest.source(searchSourceBuilder);
            SearchResponse searchResponse = restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
            return ElasticsearchUtil.resultPart(searchResponse);
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public static JSONArray rangeQuery(RestHighLevelClient restHighLevelClient, EsSerachReadEntity esSerachReadEntity) {
        try {
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            QueryBuilders.rangeQuery((String)esSerachReadEntity.getRangeField()).from((Object)esSerachReadEntity.getRangeStartValue()).to((Object)esSerachReadEntity.getRangeEndValue());
            ElasticsearchUtil.publicPart(esSerachReadEntity, searchSourceBuilder);
            SearchRequest searchRequest = new SearchRequest(new String[]{esSerachReadEntity.getIndexName()});
            searchRequest.source(searchSourceBuilder);
            SearchResponse searchResponse = restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
            return ElasticsearchUtil.resultPart(searchResponse);
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
            return null;
        }
    }
}

