/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.dde.entity.EsSearchVo;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchReadUtils {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchReadUtils.class);

    public static JSONArray termQuery(RestHighLevelClient restHighLevelClient, EsSearchVo searchVo) throws IOException {
        SearchRequest searchRequest = new SearchRequest(new String[]{searchVo.getIndexName()});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        Map<String, JSONObject> queryParameter = searchVo.getQueryParameter();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        queryParameter.forEach((key, jsonObject) -> {
            Object fieldValue = jsonObject.get((Object)"value");
            Float boots = jsonObject.getFloat("boots");
            String minimumShouldMatch = jsonObject.getString("minimumShouldMatch");
            TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)key, (Object)fieldValue);
            if (boots.floatValue() > 0.0f) {
                termQueryBuilder.boost(boots.floatValue());
            }
            boolQueryBuilder.must((QueryBuilder)termQueryBuilder);
            if (StringUtils.isNotBlank((CharSequence)minimumShouldMatch)) {
                boolQueryBuilder.minimumShouldMatch(minimumShouldMatch);
            }
        });
        searchSourceBuilder.from(searchVo.getPageSize() > 1 ? (searchVo.getPageSize() - 1) * searchVo.getPageNo() : 0);
        searchSourceBuilder.size(searchVo.getPageNo().intValue());
        searchSourceBuilder.fetchSource(searchVo.getReturnField(), searchVo.getNotReturnField());
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        String sortField = searchVo.getSortField();
        String sortOrder = searchVo.getSortOrder();
        if (StringUtils.isNotBlank((CharSequence)sortField) && StringUtils.isNotBlank((CharSequence)sortOrder)) {
            searchSourceBuilder.sort(sortField, StringUtils.equals((CharSequence)sortOrder.toUpperCase(), (CharSequence)"DESC") ? SortOrder.DESC : SortOrder.ASC);
        }
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
        return ElasticsearchReadUtils.resultPart(searchResponse);
    }

    public static JSONArray terms(Map<String, Object> parameter, int pageSiez, int pageNo) {
        return new JSONArray();
    }

    public static JSONArray match(Map<String, Object> parameter, int pageSiez, int pageNo) {
        return new JSONArray();
    }

    public static JSONArray matchAll(Map<String, Object> parameter, int pageSiez, int pageNo) {
        return new JSONArray();
    }

    public static JSONArray range(Map<String, Object> parameter, int pageSiez, int pageNo) {
        return new JSONArray();
    }

    public static JSONArray exists(Map<String, Object> parameter, int pageSiez, int pageNo) {
        return new JSONArray();
    }

    public static JSONArray must(Map<String, Object> parameter, int pageSiez, int pageNo) {
        return new JSONArray();
    }

    public static JSONArray mustNot(Map<String, Object> parameter, int pageSiez, int pageNo) {
        return new JSONArray();
    }

    public static JSONArray should(Map<String, Object> parameter, int pageSiez, int pageNo) {
        return new JSONArray();
    }

    public static JSONArray constantScore(Map<String, Object> parameter, int pageSiez, int pageNo) {
        return new JSONArray();
    }

    public static JSONArray matchPhrase(Map<String, Object> parameter, int pageSiez, int pageNo) {
        return new JSONArray();
    }

    public static JSONArray multiMatch(Map<String, Object> parameter, int pageSiez, int pageNo) {
        return new JSONArray();
    }

    private static JSONArray resultPart(SearchResponse searchResponse) {
        JSONArray resultArrays = new JSONArray();
        if (RestStatus.OK.equals((Object)searchResponse.status()) && searchResponse.getHits().getTotalHits().value > 0L) {
            SearchHits hits = searchResponse.getHits();
            for (SearchHit hit : hits) {
                JSONObject jsonObject = JSONObject.parseObject((String)hit.getSourceAsString());
                logger.debug("\u83b7\u53d6es\u6570\u636e:" + jsonObject.toJSONString());
                resultArrays.add((Object)jsonObject);
            }
        }
        return resultArrays;
    }
}

