/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.factory;

import com.centit.dde.config.ElasticSearchConfig;
import com.centit.product.metadata.po.SourceInfo;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;

public class PooledRestClientFactory
implements PooledObjectFactory<RestHighLevelClient> {
    public static final Log log = LogFactory.getLog(PooledRestClientFactory.class);
    ElasticSearchConfig elasticSearchConfig;
    SourceInfo sourceInfo;
    private static ConcurrentHashMap<String, GenericObjectPool<RestHighLevelClient>> clientPoolMap = new ConcurrentHashMap();

    public PooledRestClientFactory(ElasticSearchConfig config, SourceInfo sourceInfo) {
        this.elasticSearchConfig = config;
        this.sourceInfo = sourceInfo;
    }

    public PooledObject<RestHighLevelClient> makeObject() throws Exception {
        return new DefaultPooledObject((Object)this.elasticSearchConfig.restHighLevelClient(this.sourceInfo));
    }

    public void destroyObject(PooledObject<RestHighLevelClient> p) throws Exception {
        RestHighLevelClient client = (RestHighLevelClient)p.getObject();
        if (client != null && client.ping(RequestOptions.DEFAULT)) {
            try {
                client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean validateObject(PooledObject<RestHighLevelClient> p) {
        RestHighLevelClient client = (RestHighLevelClient)p.getObject();
        try {
            return client.ping(RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void activateObject(PooledObject<RestHighLevelClient> p) throws Exception {
        RestHighLevelClient restHighLevelClient = (RestHighLevelClient)p.getObject();
        restHighLevelClient.ping(RequestOptions.DEFAULT);
    }

    public void passivateObject(PooledObject<RestHighLevelClient> p) throws Exception {
    }

    public void setConifg(ElasticSearchConfig elasticSearchConfig) {
        this.elasticSearchConfig = elasticSearchConfig;
    }

    public static GenericObjectPool<RestHighLevelClient> obtainclientPool(ElasticSearchConfig config, SourceInfo sourceInfo) {
        GenericObjectPool clientPool = clientPoolMap.get(sourceInfo.getDatabaseCode());
        if (clientPool == null) {
            GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
            clientPool = new GenericObjectPool((PooledObjectFactory)new PooledRestClientFactory(config, sourceInfo), poolConfig);
            clientPoolMap.put(sourceInfo.getDatabaseCode(), (GenericObjectPool<RestHighLevelClient>)clientPool);
        }
        return clientPool;
    }
}

