/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.config;

import com.alibaba.fastjson.JSONObject;
import com.centit.product.metadata.po.SourceInfo;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;

public class ElasticSearchConfig {
    public static final Log log = LogFactory.getLog(ElasticSearchConfig.class);
    private static final int ADDRESS_LENGTH = 2;
    private static final String HTTP_SCHEME = "http";

    public RestHighLevelClient restHighLevelClient(SourceInfo sourceInfo) {
        RestClientBuilder restClientBuilder = this.restClientBuilder(sourceInfo.getDatabaseUrl());
        JSONObject poolData = sourceInfo.getExtProps();
        String username = sourceInfo.getUsername();
        String password = sourceInfo.getPassword();
        Integer socketTimeout = poolData.getString("socketTimeout") == null ? 10000 : Integer.valueOf(poolData.getString("socketTimeout"));
        Integer connectTimeout = poolData.getString("connectTimeout") == null ? 10000 : Integer.valueOf(poolData.getString("connectTimeout"));
        Integer connectionRequestTimeout = poolData.getString("connectionRequestTimeout") == null ? 10000 : Integer.valueOf(poolData.getString("connectionRequestTimeout"));
        Integer ioThreadCount = poolData.getString("ioThreadCount") == null ? 10 : Integer.valueOf(poolData.getString("ioThreadCount"));
        if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
            restClientBuilder.setHttpClientConfigCallback(arg_0 -> ElasticSearchConfig.lambda$restHighLevelClient$0((CredentialsProvider)credentialsProvider, arg_0));
        }
        restClientBuilder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setSocketTimeout(socketTimeout.intValue()).setConnectTimeout(connectTimeout.intValue()).setConnectionRequestTimeout(connectionRequestTimeout.intValue()));
        restClientBuilder.setHttpClientConfigCallback(httpAsyncClientBuilder -> httpAsyncClientBuilder.setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(ioThreadCount.intValue()).build()));
        restClientBuilder.setFailureListener(new RestClient.FailureListener(){

            public void onFailure(Node node) {
                super.onFailure(node);
                log.error((Object)(node.getHost() + "--->\u8be5\u8282\u70b9\u5931\u8d25\u4e86"));
            }
        });
        return new RestHighLevelClient(restClientBuilder);
    }

    public RestClientBuilder restClientBuilder(String ipAddress) {
        String[] split = ipAddress.split(",");
        HttpHost[] hosts = (HttpHost[])Arrays.stream(split).map(this::makeHttpHost).filter(Objects::nonNull).toArray(HttpHost[]::new);
        return RestClient.builder((HttpHost[])hosts);
    }

    private HttpHost makeHttpHost(String str) {
        assert (StringUtils.isNotEmpty((CharSequence)str));
        String[] address = str.split(":");
        if (address.length == 2) {
            String ip = address[0];
            int port = Integer.parseInt(address[1]);
            log.info((Object)("ES\u8fde\u63a5ip" + ip + "\u548cport:" + port));
            return new HttpHost(ip, port, HTTP_SCHEME);
        }
        log.error((Object)"\u4f20\u5165\u7684ip\u53c2\u6570\u4e0d\u6b63\u786e\uff01");
        return null;
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$restHighLevelClient$0(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

