/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.bizopt;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import com.alibaba.fastjson.JSONObject;
import com.centit.dde.bizopt.BuiltInOperation;
import com.centit.dde.config.ElasticSearchConfig;
import com.centit.dde.core.BizModel;
import com.centit.dde.core.BizOperation;
import com.centit.dde.core.DataSet;
import com.centit.dde.core.SimpleDataSet;
import com.centit.dde.entity.EsSearchWriteEntity;
import com.centit.dde.factory.PooledRestClientFactory;
import com.centit.dde.utils.ElasticsearchWriteUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseSingleData;
import com.centit.product.metadata.dao.SourceInfoDao;
import com.centit.product.metadata.po.SourceInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;

public class EsWriteBizOperation
implements BizOperation {
    public static final Log log = LogFactory.getLog(EsWriteBizOperation.class);
    private SourceInfoDao sourceInfoDao;
    private static final ConcurrentHashMap<GenericObjectPool<RestHighLevelClient>, List<String>> indexNameCache = new ConcurrentHashMap();

    public EsWriteBizOperation() {
    }

    public EsWriteBizOperation(SourceInfoDao sourceInfoDao) {
        this.sourceInfoDao = sourceInfoDao;
    }

    public ResponseData runOpt(BizModel bizModel, JSONObject bizOptJson) throws Exception {
        return this.writeEs(bizModel, bizOptJson);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseData writeEs(BizModel bizModel, JSONObject bizOptJson) throws Exception {
        EsSearchWriteEntity esSearchWriteEntity = (EsSearchWriteEntity)JSONObject.parseObject((String)bizOptJson.toJSONString(), EsSearchWriteEntity.class);
        String source = esSearchWriteEntity.getSource();
        DataSet dataSet = bizModel.getDataSet(source);
        List data = dataSet.getDataAsList();
        ArrayList<String> addData = new ArrayList<String>();
        for (Map datum : data) {
            String jsonData = JSONObject.toJSONString((Object)datum);
            addData.add(jsonData);
        }
        TimeInterval timer = DateUtil.timer();
        SourceInfo sourceInfo = this.sourceInfoDao.getDatabaseInfoById(esSearchWriteEntity.getDataSourceId());
        log.debug((Object)("\u83b7\u53d6\u5143\u6570\u636e\u4fe1\u606f\u8017\u65f6\uff1a" + timer.intervalRestart() + "ms,\u83b7\u53d6\u5143\u6570\u636e\u4fe1\u606f\uff1a" + sourceInfo.toString()));
        GenericObjectPool<RestHighLevelClient> restHighLevelClientGenericObjectPool = PooledRestClientFactory.obtainclientPool(new ElasticSearchConfig(), sourceInfo);
        RestHighLevelClient restHighLevelClient = null;
        try {
            restHighLevelClient = (RestHighLevelClient)restHighLevelClientGenericObjectPool.borrowObject();
            log.debug((Object)("\u83b7restHighLevelClient\u8017\u65f6\uff1a" + timer.intervalRestart() + "ms"));
            String indexName = esSearchWriteEntity.getIndexName();
            if (!indexNameCache.containsKey(restHighLevelClientGenericObjectPool)) {
                boolean exists = restHighLevelClient.exists(new GetRequest(indexName), RequestOptions.DEFAULT);
                if (!exists) {
                    ResponseData responseData = BuiltInOperation.getResponseData((int)0, (int)500, (String)(bizOptJson.getString("SetsName") + ":" + indexName + "\u7d22\u5f15\u4e0d\u5b58\u5728\uff01"));
                    return responseData;
                }
                List<String> synchronizedList = Collections.synchronizedList(new ArrayList());
                synchronizedList.add(indexName);
                indexNameCache.put(restHighLevelClientGenericObjectPool, synchronizedList);
            } else {
                List<String> synchronizedList = indexNameCache.get(restHighLevelClientGenericObjectPool);
                if (!synchronizedList.contains(indexName)) {
                    boolean exists = restHighLevelClient.exists(new GetRequest(indexName), RequestOptions.DEFAULT);
                    if (!exists) {
                        ResponseData responseData = BuiltInOperation.getResponseData((int)0, (int)500, (String)(bizOptJson.getString("SetsName") + ":" + indexName + "\u7d22\u5f15\u4e0d\u5b58\u5728\uff01"));
                        return responseData;
                    }
                    synchronizedList.add(indexName);
                }
            }
            Boolean indexResponse = ElasticsearchWriteUtils.batchSaveDocuments(restHighLevelClient, addData, esSearchWriteEntity);
            log.info((Object)("\u63d2\u5165ES\u6570\u636e\u8017\u65f6\uff1a" + timer.intervalRestart() + "ms"));
            bizModel.putDataSet(esSearchWriteEntity.getId(), (DataSet)new SimpleDataSet((Object)indexResponse));
            ResponseSingleData responseSingleData = ResponseSingleData.makeResponseData((Object)indexResponse);
            return responseSingleData;
        }
        finally {
            restHighLevelClientGenericObjectPool.returnObject((Object)restHighLevelClient);
            log.debug((Object)"restHighLevelClient\u653e\u56de\u8fde\u63a5\u6c60\u4e2d");
        }
    }
}

