/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.bizopt;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.dde.config.ElasticSearchConfig;
import com.centit.dde.core.BizModel;
import com.centit.dde.core.BizOperation;
import com.centit.dde.core.DataSet;
import com.centit.dde.core.SimpleDataSet;
import com.centit.dde.entity.EsSerachReadEntity;
import com.centit.dde.factory.PooledRestClientFactory;
import com.centit.dde.utils.ElasticsearchUtil;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseSingleData;
import com.centit.product.metadata.dao.SourceInfoDao;
import com.centit.product.metadata.po.SourceInfo;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.elasticsearch.client.RestHighLevelClient;

public class EsReadBizOperation
implements BizOperation {
    public static final Log log = LogFactory.getLog(EsReadBizOperation.class);
    private SourceInfoDao sourceInfoDao;

    public EsReadBizOperation() {
    }

    public EsReadBizOperation(SourceInfoDao sourceInfoDao) {
        this.sourceInfoDao = sourceInfoDao;
    }

    public ResponseData runOpt(BizModel bizModel, JSONObject bizOptJson) throws Exception {
        EsSerachReadEntity esSerachReadEntity = (EsSerachReadEntity)JSONObject.parseObject((String)bizOptJson.toJSONString(), EsSerachReadEntity.class);
        return this.queryEs(bizModel, esSerachReadEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseData queryEs(BizModel bizModel, EsSerachReadEntity esSerachReadEntity) throws Exception {
        TimeInterval timer = DateUtil.timer();
        SourceInfo sourceInfo = this.sourceInfoDao.getDatabaseInfoById(esSerachReadEntity.getDataSourceId());
        log.debug((Object)("\u83b7\u53d6\u5143\u6570\u636e\u4fe1\u606f\u8017\u65f6\uff1a" + timer.intervalRestart() + "ms,\u83b7\u53d6\u5143\u6570\u636e\u4fe1\u606f\uff1a" + sourceInfo.toString()));
        GenericObjectPool<RestHighLevelClient> restHighLevelClientGenericObjectPool = PooledRestClientFactory.obtainclientPool(new ElasticSearchConfig(), sourceInfo);
        RestHighLevelClient restHighLevelClient = null;
        try {
            JSONArray resultData;
            restHighLevelClient = (RestHighLevelClient)restHighLevelClientGenericObjectPool.borrowObject();
            log.debug((Object)("\u83b7restHighLevelClient\u8017\u65f6\uff1a" + timer.intervalRestart() + "ms"));
            switch (esSerachReadEntity.getQueryType()) {
                case "1": {
                    resultData = ElasticsearchUtil.accurateQuery(restHighLevelClient, esSerachReadEntity);
                    break;
                }
                case "2": {
                    resultData = ElasticsearchUtil.matchQuery(restHighLevelClient, esSerachReadEntity);
                    break;
                }
                case "3": {
                    resultData = ElasticsearchUtil.rangeQuery(restHighLevelClient, esSerachReadEntity);
                    break;
                }
                default: {
                    resultData = ElasticsearchUtil.matchAllQuery(restHighLevelClient, esSerachReadEntity);
                }
            }
            log.info((Object)("\u67e5\u8be2\u7c7b\u578b:" + esSerachReadEntity.getQueryType() + ",\u67e5\u8be2ES\u8017\u65f6\uff1a" + timer.intervalRestart() + "ms"));
            SimpleDataSet dataSet = new SimpleDataSet();
            dataSet.setData((Object)resultData);
            bizModel.putDataSet(esSerachReadEntity.getId(), (DataSet)dataSet);
            ResponseSingleData responseSingleData = ResponseSingleData.makeResponseData((Object)resultData);
            return responseSingleData;
        }
        finally {
            restHighLevelClientGenericObjectPool.returnObject((Object)restHighLevelClient);
            log.debug((Object)"restHighLevelClient\u653e\u56de\u8fde\u63a5\u6c60\u4e2d");
        }
    }

    public static Map<String, Object> jsonStrToMap(String json) {
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.putAll((Map<String, Object>)jsonObject);
        return valueMap;
    }
}

