package com.centit.dde.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.dde.entity.EsSearchVo;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.Map;

/**
 * es查询工具类
 */
public class ElasticsearchReadUtils {
    private static  final Logger logger = LoggerFactory.getLogger(ElasticsearchReadUtils.class);
    //term 查询
    public static JSONArray termQuery(RestHighLevelClient restHighLevelClient,EsSearchVo searchVo) throws IOException {
        SearchRequest searchRequest = new SearchRequest(searchVo.getIndexName());
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        Map<String, JSONObject> queryParameter = searchVo.getQueryParameter();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        queryParameter.forEach((key,jsonObject)->{
            Object fieldValue = jsonObject.get("value");
            Float boots = jsonObject.getFloat("boots");
            String minimumShouldMatch = jsonObject.getString("minimumShouldMatch");
            TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery(key, fieldValue);
            //权重
            if (boots>0){
                termQueryBuilder.boost(boots);
            }
            boolQueryBuilder.must(termQueryBuilder);
            //最小匹配度
            if (StringUtils.isNotBlank(minimumShouldMatch)){
                boolQueryBuilder.minimumShouldMatch(minimumShouldMatch);
            }
        });
        searchSourceBuilder.from((searchVo.getPageSize()>1)?(searchVo.getPageSize()-1)* searchVo.getPageNo():0);
        searchSourceBuilder.size(searchVo.getPageNo());
       // searchSourceBuilder.explain(true);
        //设置查询时返回的字段和不返回的字段信息，第一个参数为要返回的字段，第二个为不返回的字段
        searchSourceBuilder.fetchSource(searchVo.getReturnField(),searchVo.getNotReturnField());
        searchSourceBuilder.query(boolQueryBuilder);
        String sortField = searchVo.getSortField();
        String sortOrder = searchVo.getSortOrder();
        if (StringUtils.isNotBlank(sortField)&&StringUtils.isNotBlank(sortOrder)){
            searchSourceBuilder.sort(sortField, StringUtils.equals(sortOrder.toUpperCase(),"DESC")?SortOrder.DESC:SortOrder.ASC);
        }
        searchRequest.source(searchSourceBuilder);
        // 执行查询，然后处理响应结果
        SearchResponse searchResponse = restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
        return resultPart(searchResponse);
    }



    //terms
    public static JSONArray terms(Map<String,Object> parameter,int pageSiez,int pageNo){

        return new JSONArray();
    }

    //match
    public static JSONArray match(Map<String,Object> parameter,int pageSiez,int pageNo){

        return new JSONArray();
    }
    //match_all
    public static JSONArray matchAll(Map<String,Object> parameter,int pageSiez,int pageNo){

        return new JSONArray();
    }
    //range
    public static JSONArray range(Map<String,Object> parameter,int pageSiez,int pageNo){

        return new JSONArray();
    }
    //exists
    public static JSONArray exists(Map<String,Object> parameter,int pageSiez,int pageNo){

        return new JSONArray();
    }
    // must
    public static JSONArray must(Map<String,Object> parameter,int pageSiez,int pageNo){

        return new JSONArray();
    }
    // must_not
    public static JSONArray mustNot(Map<String,Object> parameter,int pageSiez,int pageNo){

        return new JSONArray();
    }
    //should
    public static JSONArray should(Map<String,Object> parameter,int pageSiez,int pageNo){

        return new JSONArray();
    }
    //constant_score
    public static JSONArray constantScore(Map<String,Object> parameter,int pageSiez,int pageNo){

        return new JSONArray();
    }
    //match_phrase
    public static JSONArray matchPhrase(Map<String,Object> parameter,int pageSiez,int pageNo){

        return new JSONArray();
    }
    //multi_match
    public static JSONArray multiMatch(Map<String,Object> parameter,int pageSiez,int pageNo){

        return new JSONArray();
    }

    //查询返回结果部分封装
    private static JSONArray resultPart(SearchResponse searchResponse){
        JSONArray resultArrays= new JSONArray();
        // 根据状态和数据条数验证是否返回了数据
        if (RestStatus.OK.equals(searchResponse.status()) && searchResponse.getHits().getTotalHits().value > 0) {
            SearchHits hits = searchResponse.getHits();
            for (SearchHit hit : hits) {
                JSONObject jsonObject = JSONObject.parseObject(hit.getSourceAsString());
                // 输出查询信息
                logger.debug("获取es数据:"+jsonObject.toJSONString());
                resultArrays.add(jsonObject);
            }
        }
        return resultArrays;
    }
}
