package com.centit.dde.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

//查询参数封装
@Data
@NoArgsConstructor
@AllArgsConstructor
public class QueryParameter {
    @ApiModelProperty(value = "查询权重，提升文档搜索评分的重要因素,精确查询和匹配查询可用")
    private Float boots;
    @ApiModelProperty(value = "查询字段")
    private String field;
    @ApiModelProperty(value = "查询字段值")
    private String value;
    @ApiModelProperty(value = "指定查询分词器（匹配查询时才有效,默认入库时的分词器）")
    private String analyzer;
    //查询最小匹配度   可以是百分比   也可以是整型  这里设置的是百分比 直观
    @ApiModelProperty(value = "查询最小匹配度（百分比）")
    private String queryMinimumProportion;
}
