package com.centit.dde.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

/**
 * es查询参数封装
 */
@ApiModel
@Data
@NoArgsConstructor
@AllArgsConstructor
public class EsSerachReadEntity {
    @ApiModelProperty(value = "本节点数据集id")
    private String id;
    @ApiModelProperty(value = "类型")
    private String type;
    @ApiModelProperty(value = "索引名称")
    private String indexName;
    @ApiModelProperty(value = "查询类型   1：精确查询   2条件查询  3 范围查询  不传值为：分页查询（查询时填写）")
    private String queryType;
    @ApiModelProperty(value = "查询字段 field  查询字段值（查询时填写）")
    private List<QueryParameter> queryFieldMap;
    @ApiModelProperty(value = "当前页码（分页查询时填写）")
    private Integer pageNo;
    @ApiModelProperty(value = "查询调试（分页查询时填写）")
    private Integer pageSize;
    @ApiModelProperty(value = "查询返回字段")
    private String returnField[];
    @ApiModelProperty(value = "查询不返回字段")
    private String notReturnField[];
    @ApiModelProperty(value = "排序字段")
    private Map<String,String> sortFieldMap;
    @ApiModelProperty(value = "元数据库中对于业务的数据库连接信息id")
    private String dataSourceId;
    @ApiModelProperty(value = "范围查询时使用，范围字段名")
    private String rangeField;
    @ApiModelProperty(value = "范围查询起始值")
    private String rangeStartValue;
    @ApiModelProperty(value = "范围查询结束值")
    private String rangeEndValue;
}
