package com.centit.dde.entity;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

/**
 * es查询参数封装
 */
@ApiModel(value = "es查询基本信息")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class EsSearchVo {
    @ApiModelProperty(value = "索引名称")
    private String indexName;

    @ApiModelProperty(value = "查询类型")
    private String queryType;

    @ApiModelProperty(value = "查询参数")
    private Map<String, JSONObject> queryParameter;

    @ApiModelProperty(value = "查询个数")
    private Integer pageSize;

    @ApiModelProperty(value = "页码")
    private Integer pageNo;

    @ApiModelProperty(value = "排序字段")
    private String sortField;

    @ApiModelProperty(value = "排序值")
    private String sortOrder;

    @ApiModelProperty(value = "查询结果返回字段")
    private String[] returnField;

    @ApiModelProperty(value = "查询结果不返回的字段")
    private String[] notReturnField;
}
