/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.datamoving;

import com.centit.dde.po.DataPacket;
import com.centit.dde.po.DataPacketInterface;
import com.centit.dde.services.DataPacketService;
import com.centit.dde.services.impl.TaskRun;
import com.centit.fileserver.common.FileStore;
import com.centit.fileserver.utils.OsFileStore;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.stereotype.Controller;

@SpringBootApplication
@ComponentScan(basePackages={"com.centit"}, excludeFilters={@ComponentScan.Filter(value={Controller.class})})
public class DataMovingApplication {
    @Value(value="${framework.app.home}")
    private String appHome;

    @Bean
    public FileStore fileStore() {
        return new OsFileStore(this.appHome + "/upload");
    }

    public static void main(String[] args) {
        if (args == null || args.length < 1) {
            return;
        }
        ConfigurableApplicationContext context = SpringApplication.run(DataMovingApplication.class, (String[])args);
        TaskRun taskRun = (TaskRun)context.getBean(TaskRun.class);
        DataPacketService dataPacketService = (DataPacketService)context.getBean(DataPacketService.class);
        DataPacket dataPacket = dataPacketService.getDataPacket(args[0]);
        taskRun.runTask((DataPacketInterface)dataPacket, null);
        int exitCode = SpringApplication.exit((ApplicationContext)context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
        System.exit(exitCode);
    }
}

