/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.datamoving;

import com.centit.dde.datamoving.service.TaskRun;
import com.centit.fileserver.common.FileStore;
import com.centit.fileserver.utils.OsFileStore;
import com.centit.product.dataopt.core.BizModel;
import java.sql.SQLException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.stereotype.Controller;

@SpringBootApplication
@ComponentScan(basePackages={"com.centit"}, excludeFilters={@ComponentScan.Filter(value={Controller.class})})
public class DataMovingApplication {
    @Value(value="${framework.app.home}")
    private String appHome;

    @Bean
    public FileStore fileStore() {
        return new OsFileStore(this.appHome + "/upload");
    }

    public static void main(String[] args) throws SQLException {
        if (args == null || args.length < 1) {
            return;
        }
        ConfigurableApplicationContext context = SpringApplication.run(DataMovingApplication.class, (String[])args);
        TaskRun taskRun = (TaskRun)context.getBean(TaskRun.class);
        BizModel bizModel = taskRun.runTask(args[0]);
        System.out.println(bizModel.getModelName());
    }
}

