/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.config;

import com.alibaba.nacos.api.annotation.NacosProperties;
import com.alibaba.nacos.spring.context.annotation.config.EnableNacosConfig;
import com.alibaba.nacos.spring.context.annotation.config.NacosPropertySource;
import com.alibaba.nacos.spring.context.annotation.config.NacosPropertySources;
import com.centit.fileserver.client.FileClient;
import com.centit.fileserver.client.FileClientImpl;
import com.centit.fileserver.client.FileInfoOptClient;
import com.centit.fileserver.common.FileInfoOpt;
import com.centit.framework.components.impl.NotificationCenterImpl;
import com.centit.framework.config.SpringSecurityDaoConfig;
import com.centit.framework.core.service.DataScopePowerManager;
import com.centit.framework.core.service.impl.DataScopePowerManagerImpl;
import com.centit.framework.jdbc.config.JdbcConfig;
import com.centit.framework.model.adapter.NotificationCenter;
import com.centit.framework.security.model.StandardPasswordEncoderImpl;
import io.lettuce.core.RedisClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Controller;

@EnableAsync
@EnableScheduling
@Import(value={SpringSecurityDaoConfig.class, JdbcConfig.class})
@ComponentScan(basePackages={"com.centit"}, excludeFilters={@ComponentScan.Filter(type=FilterType.ANNOTATION, value={Controller.class})})
@Configuration
@EnableNacosConfig(globalProperties=@NacosProperties(serverAddr="${nacos.server-addr}"))
@NacosPropertySources(value={@NacosPropertySource(dataId="${nacos.system-dataid}", groupId="CENTIT", autoRefreshed=true)})
public class ServiceConfig {
    Logger logger = LoggerFactory.getLogger(ServiceConfig.class);
    @Value(value="${app.home:./}")
    private String appHome;
    @Value(value="${fileserver.url}")
    private String fileserver;
    @Value(value="${redis.default.host}")
    private String redisHost;

    @Bean(value={"passwordEncoder"})
    public StandardPasswordEncoderImpl passwordEncoder() {
        return new StandardPasswordEncoderImpl();
    }

    @Bean
    public RedisClient redisClient() {
        return RedisClient.create((String)this.redisHost);
    }

    @Bean
    public NotificationCenter notificationCenter() {
        NotificationCenterImpl notificationCenter = new NotificationCenterImpl();
        notificationCenter.initDummyMsgSenders();
        return notificationCenter;
    }

    @Bean
    public DataScopePowerManager queryDataScopeFilter() {
        return new DataScopePowerManagerImpl();
    }

    @Bean
    public FileClient fileClient() {
        FileClientImpl fileClient = new FileClientImpl();
        fileClient.init(this.fileserver, this.fileserver, "u0000000", "000000", this.fileserver);
        return fileClient;
    }

    @Bean
    public FileInfoOpt fileInfoOpt(@Autowired FileClient fileClient) {
        FileInfoOptClient fileStoreBean = new FileInfoOptClient();
        fileStoreBean.setFileClient(fileClient);
        return fileStoreBean;
    }
}

