/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.config;

import com.centit.fileserver.client.ClientAsFileStore;
import com.centit.fileserver.client.FileClient;
import com.centit.fileserver.client.FileClientImpl;
import com.centit.framework.components.impl.NotificationCenterImpl;
import com.centit.framework.components.impl.TextOperationLogWriterImpl;
import com.centit.framework.config.SpringSecurityDaoConfig;
import com.centit.framework.ip.app.config.IPOrStaticAppSystemBeanConfig;
import com.centit.framework.jdbc.config.JdbcConfig;
import com.centit.framework.model.adapter.NotificationCenter;
import com.centit.framework.model.adapter.OperationLogWriter;
import com.centit.framework.security.model.StandardPasswordEncoderImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Controller;
import redis.clients.jedis.JedisPool;

@EnableAsync
@EnableScheduling
@Import(value={IPOrStaticAppSystemBeanConfig.class, SpringSecurityDaoConfig.class, JdbcConfig.class})
@ComponentScan(basePackages={"com.centit"}, excludeFilters={@ComponentScan.Filter(type=FilterType.ANNOTATION, value={Controller.class})})
@Configuration
public class ServiceConfig {
    @Value(value="${app.home:./}")
    private String appHome;
    @Value(value="${fileserver.url}")
    private String fileserver;
    @Value(value="${redis.host}")
    private String redisHost;
    @Value(value="${redis.port}")
    private int redisPort;

    @Bean(value={"passwordEncoder"})
    public StandardPasswordEncoderImpl passwordEncoder() {
        return new StandardPasswordEncoderImpl();
    }

    @Bean
    public JedisPool jedisPool() {
        JedisPool jedisPool = new JedisPool(this.redisHost, this.redisPort);
        return jedisPool;
    }

    @Bean
    public NotificationCenter notificationCenter() {
        NotificationCenterImpl notificationCenter = new NotificationCenterImpl();
        notificationCenter.initDummyMsgSenders();
        return notificationCenter;
    }

    @Bean
    @Lazy(value=false)
    public OperationLogWriter operationLogWriter() {
        TextOperationLogWriterImpl operationLog = new TextOperationLogWriterImpl();
        operationLog.setOptLogHomePath(this.appHome + "/logs");
        operationLog.init();
        return operationLog;
    }

    @Bean
    public FileClientImpl fileClient() {
        FileClientImpl fileClient = new FileClientImpl();
        fileClient.init(this.fileserver, this.fileserver, "u0000000", "000000", this.fileserver);
        return fileClient;
    }

    @Bean
    public ClientAsFileStore fileStore(@Autowired FileClientImpl fileClient) {
        ClientAsFileStore fileStoreBean = new ClientAsFileStore();
        fileStoreBean.setFileClient((FileClient)fileClient);
        return fileStoreBean;
    }
}

