/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.controller;

import com.centit.dde.po.TaskExchange;
import com.centit.dde.service.TaskExchangeManager;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="\u4ea4\u6362\u4efb\u52a1", tags={"\u4ea4\u6362\u4efb\u52a1"})
@RequestMapping(value={"taskExchange"})
public class TaskExchangeController
extends BaseController {
    private static final Log log = LogFactory.getLog(TaskExchangeController.class);
    @Autowired
    private TaskExchangeManager taskExchangeManager;

    @PostMapping
    @ApiOperation(value="\u65b0\u589e\u4efb\u52a1")
    @WrapUpResponseBody
    public void createTaskExchange(TaskExchange taskExchange) {
        this.taskExchangeManager.createTaskExchange(taskExchange);
    }

    @PutMapping(value={"/{taskId}"})
    @ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID")
    @ApiOperation(value="\u66f4\u65b0\u4efb\u52a1")
    @WrapUpResponseBody
    public void updateTaskExchange(@PathVariable String taskId, TaskExchange taskExchange) {
        taskExchange.setTaskId(taskId);
        this.taskExchangeManager.updateTaskExchange(taskExchange);
    }

    @DeleteMapping(value={"/{taskId}"})
    @ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID")
    @ApiOperation(value="\u5220\u9664\u4efb\u52a1")
    @WrapUpResponseBody
    public void delTaskExchange(@PathVariable String taskId) {
        this.taskExchangeManager.delTaskExchangeById(taskId);
    }

    @GetMapping
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u4efb\u52a1")
    @WrapUpResponseBody
    public PageQueryResult<TaskExchange> listTaskExchange(PageDesc pageDesc) {
        List taskExchanges = this.taskExchangeManager.listTaskExchange(new HashMap(), pageDesc);
        return PageQueryResult.createResult((Collection)taskExchanges, (PageDesc)pageDesc);
    }

    @GetMapping(value={"/{taskId}"})
    @ApiOperation(value="\u67e5\u8be2\u4e00\u4e2a\u4efb\u52a1")
    @WrapUpResponseBody
    public TaskExchange getTaskExchange(@PathVariable String taskId) {
        TaskExchange taskExchange = this.taskExchangeManager.getTaskExchange(taskId);
        return taskExchange;
    }
}

