/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.agent.service;

import com.centit.dde.agent.service.PathConfig;
import com.centit.framework.components.impl.NotificationCenterImpl;
import com.centit.framework.components.impl.TextOperationLogWriterImpl;
import com.centit.framework.core.service.DataScopePowerManager;
import com.centit.framework.core.service.impl.DataScopePowerManagerImpl;
import com.centit.framework.model.adapter.NotificationCenter;
import com.centit.framework.model.adapter.OperationLogWriter;
import com.centit.framework.model.adapter.UserUnitFilterCalcContextFactory;
import com.centit.framework.security.StandardPasswordEncoderImpl;
import com.centit.search.service.ESServerConfig;
import com.centit.search.utils.ImagePdfTextExtractor;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.workflow.service.impl.SystemUserUnitCalcContextFactoryImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
public class ServiceConfig
implements EnvironmentAware {
    private Environment env;
    private final PathConfig pathConfig;

    public void setEnvironment(Environment environment) {
        this.env = environment;
    }

    @Autowired
    public ServiceConfig(PathConfig pathConfig) {
        this.pathConfig = pathConfig;
    }

    @Bean
    public SchedulerFactoryBean schedulerFactoryBean() {
        SchedulerFactoryBean schedulerFactoryBean = new SchedulerFactoryBean();
        return schedulerFactoryBean;
    }

    @Bean
    public NotificationCenter notificationCenter() {
        NotificationCenterImpl notificationCenter = new NotificationCenterImpl();
        notificationCenter.initDummyMsgSenders();
        return notificationCenter;
    }

    @Bean
    public UserUnitFilterCalcContextFactory userUnitFilterFactory() {
        return new SystemUserUnitCalcContextFactoryImpl();
    }

    @Bean
    public OperationLogWriter operationLogWriter() {
        TextOperationLogWriterImpl textOperationLogWriter = new TextOperationLogWriterImpl();
        textOperationLogWriter.setOptLogHomePath(this.pathConfig.getLogs());
        return textOperationLogWriter;
    }

    @Bean(value={"passwordEncoder"})
    public StandardPasswordEncoderImpl passwordEncoder() {
        return new StandardPasswordEncoderImpl();
    }

    @Bean
    public DataScopePowerManager queryDataScopeFilter() {
        return new DataScopePowerManagerImpl();
    }

    @Bean
    public ImagePdfTextExtractor.OcrServerHost ocrServerHost() {
        ImagePdfTextExtractor.OcrServerHost ocrServer = ImagePdfTextExtractor.fetchDefaultOrrServer();
        String ocrServerHost = this.env.getProperty("ocr.server.url");
        if (StringUtils.isNotBlank((CharSequence)ocrServerHost)) {
            String stemp = this.env.getProperty("ocr.server.auth.api");
            if (StringUtils.isNotBlank((CharSequence)stemp)) {
                ocrServer.setAuthorUrl(ocrServerHost + stemp);
            }
            if (StringUtils.isNotBlank((CharSequence)(stemp = this.env.getProperty("ocr.server.ocr.api")))) {
                ocrServer.setOrcUrl(ocrServerHost + stemp);
            }
            if (StringUtils.isNotBlank((CharSequence)(stemp = this.env.getProperty("ocr.server.auth.username")))) {
                ocrServer.setUserName(stemp);
            }
            if (StringUtils.isNotBlank((CharSequence)(stemp = this.env.getProperty("ocr.server.auth.password")))) {
                ocrServer.setPassword(stemp);
            }
        }
        return ocrServer;
    }

    @Bean
    public ESServerConfig esServerConfig() {
        ESServerConfig config = new ESServerConfig();
        config.setServerHostIp(this.env.getProperty("elasticsearch.server.ip"));
        config.setServerHostPort(this.env.getProperty("elasticsearch.server.port"));
        config.setClusterName(this.env.getProperty("elasticsearch.server.cluster"));
        config.setOsId(this.env.getProperty("elasticsearch.osId"));
        config.setUsername(this.env.getProperty("elasticsearch.server.username"));
        config.setPassword(this.env.getProperty("elasticsearch.server.password"));
        config.setMinScore(NumberBaseOpt.parseFloat((String)this.env.getProperty("elasticsearch.filter.minScore"), (Float)Float.valueOf(0.5f)).floatValue());
        return config;
    }
}

