/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.agent.service;

import com.centit.dde.adapter.dao.DataPacketDao;
import com.centit.dde.adapter.po.DataPacket;
import com.centit.dde.agent.service.PathConfig;
import com.centit.dde.agent.service.RunTaskJob;
import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.model.adapter.OperationLogWriter;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.quartz.QuartzJobUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.quartz.CronTrigger;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class TaskSchedulers {
    protected static final Logger logger = LoggerFactory.getLogger(TaskSchedulers.class);
    private final DataPacketDao dataPacketDao;
    private final Scheduler scheduler;
    private final OperationLogWriter operationLogWriter;
    private static String staticTaskMd5 = "";
    private static ConcurrentHashMap<String, Object> queryParams = new ConcurrentHashMap(2);

    @Autowired
    public TaskSchedulers(@Autowired DataPacketDao dataPacketDao, @Autowired PlatformEnvironment dbPlatformEnvironment, @Autowired Scheduler scheduler, @Autowired OperationLogWriter operationLogWriter, @Autowired PathConfig pathConfig) {
        this.dataPacketDao = dataPacketDao;
        this.scheduler = scheduler;
        this.operationLogWriter = operationLogWriter;
        CodeRepositoryCache.setPlatformEnvironment((PlatformEnvironment)dbPlatformEnvironment);
        queryParams.put("taskType", "2");
        queryParams.put("isValid", true);
        queryParams.put("isDisable", false);
        if (pathConfig.getOptId() != null && pathConfig.getOptId().length > 0) {
            queryParams.put("optId_in", pathConfig.getOptId());
        }
    }

    private void refreshTask() {
        CopyOnWriteArrayList list = new CopyOnWriteArrayList(this.dataPacketDao.listObjectsByProperties((Map)queryParams));
        if (this.isEqualMd5(list)) {
            return;
        }
        CopyOnWriteArraySet triggerKeys = null;
        try {
            triggerKeys = new CopyOnWriteArraySet(this.scheduler.getTriggerKeys(GroupMatcher.anyTriggerGroup()));
        }
        catch (SchedulerException e) {
            logger.error("get trigger keys error", (Throwable)e);
            OperationLogCenter.log((OperationLog)OperationLog.create().level("1").operation("refreshTask").user("scheduler").method("getTriggerKeys").content("get trigger keys error"));
            return;
        }
        for (DataPacket dataPacket : list) {
            if (StringUtils.isBlank((CharSequence)dataPacket.getTaskCron())) continue;
            int i = 0;
            for (TriggerKey tKey : triggerKeys) {
                if (!tKey.getName().equals(dataPacket.getPacketId())) continue;
                ++i;
                try {
                    CronTrigger quartzTrigger = (CronTrigger)this.scheduler.getTrigger(tKey);
                    if (quartzTrigger.getCronExpression().equals(dataPacket.getTaskCron())) break;
                    QuartzJobUtils.createOrReplaceCronJob((Scheduler)this.scheduler, (String)dataPacket.getPacketId(), (String)dataPacket.getOptId(), (String)"task", (String)dataPacket.getTaskCron(), (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"taskExchange", dataPacket}));
                }
                catch (SchedulerException e) {
                    logger.error("replace CronJob " + dataPacket.getPacketId() + " error", (Throwable)e);
                    OperationLogCenter.log((OperationLog)OperationLog.create().level("1").operation("refreshTask").user("scheduler").method("replaceCronJob").content("get trigger keys error").newObject((Object)dataPacket));
                }
                break;
            }
            if (i != 0) continue;
            try {
                QuartzJobUtils.createOrReplaceCronJob((Scheduler)this.scheduler, (String)dataPacket.getPacketId(), (String)dataPacket.getOptId(), (String)"task", (String)dataPacket.getTaskCron(), (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"taskExchange", dataPacket}));
            }
            catch (SchedulerException e) {
                logger.error("create CronJob " + dataPacket.getPacketId() + " error", (Throwable)e);
                OperationLogCenter.log((OperationLog)OperationLog.create().level("1").operation("refreshTask").user("scheduler").method("createCronJob").content("get trigger keys error").newObject((Object)dataPacket));
            }
        }
        for (TriggerKey tKey : triggerKeys) {
            boolean found = false;
            for (DataPacket ll : list) {
                TriggerKey triggerKey = TriggerKey.triggerKey((String)ll.getPacketId(), (String)ll.getOptId());
                if (!tKey.equals((Object)triggerKey)) continue;
                found = true;
                break;
            }
            if (found) continue;
            try {
                QuartzJobUtils.deleteJob((Scheduler)this.scheduler, (String)tKey.getName(), (String)tKey.getGroup());
            }
            catch (SchedulerException e) {
                logger.error("delete CronJob " + tKey.getName() + " error", (Throwable)e);
                OperationLogCenter.log((OperationLog)OperationLog.create().level("1").operation("refreshTask").user("scheduler").method("deleteCronJob").content("get trigger keys error").newObject((Object)tKey));
            }
        }
    }

    @PostConstruct
    public void init() throws SchedulerException {
        OperationLogCenter.initOperationLogWriter((OperationLogWriter)this.operationLogWriter);
        QuartzJobUtils.registerJobType((String)"task", RunTaskJob.class);
        this.scheduler.start();
    }

    @Scheduled(fixedDelay=50000L)
    public void work() {
        this.refreshTask();
    }

    private boolean isEqualMd5(List<DataPacket> list) {
        boolean result = false;
        StringBuffer stringBuffer = new StringBuffer(100);
        for (DataPacket i : list) {
            stringBuffer.append(i.getTaskCron());
        }
        String taskMd5 = "";
        try {
            int length;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            ByteArrayInputStream is = new ByteArrayInputStream(stringBuffer.toString().getBytes());
            while ((length = is.read(buffer)) != -1) {
                md5.update(buffer, 0, length);
            }
            taskMd5 = new String(Hex.encodeHex((byte[])md5.digest()));
        }
        catch (IOException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        if (taskMd5.equals(staticTaskMd5)) {
            result = true;
        } else {
            staticTaskMd5 = taskMd5;
        }
        return result;
    }
}

