/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.agent.service;

import com.centit.dde.agent.service.PathConfig;
import com.centit.dde.agent.service.RunTaskJob;
import com.centit.dde.dao.DataPacketDao;
import com.centit.dde.po.DataPacket;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.model.adapter.OperationLogWriter;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.quartz.QuartzJobUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.binary.Hex;
import org.quartz.CronTrigger;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class TaskSchedulers {
    private final DataPacketDao dataPacketDao;
    private final Scheduler scheduler;
    private final OperationLogWriter operationLogWriter;
    private static String staticTaskMd5 = "";
    private static ConcurrentHashMap<String, Object> queryParams = new ConcurrentHashMap(2);

    @Autowired
    public TaskSchedulers(DataPacketDao dataPacketDao, Scheduler scheduler, OperationLogWriter operationLogWriter, PathConfig pathConfig) {
        this.dataPacketDao = dataPacketDao;
        this.scheduler = scheduler;
        this.operationLogWriter = operationLogWriter;
        queryParams.put("taskType", "2");
        queryParams.put("isValid", "T");
        if (pathConfig.getOwnGroups() != null && pathConfig.getOwnGroups().length > 0) {
            queryParams.put("ownGroup_in", pathConfig.getOwnGroups());
        }
    }

    private boolean isEqualMd5(List<DataPacket> list) {
        boolean result = false;
        StringBuffer stringBuffer = new StringBuffer(100);
        for (DataPacket i : list) {
            stringBuffer.append(i.getTaskCron());
        }
        String taskMd5 = "";
        try {
            int length;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            ByteArrayInputStream is = new ByteArrayInputStream(stringBuffer.toString().getBytes());
            while ((length = is.read(buffer)) != -1) {
                md5.update(buffer, 0, length);
            }
            taskMd5 = new String(Hex.encodeHex((byte[])md5.digest()));
        }
        catch (IOException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        if (taskMd5.equals(staticTaskMd5)) {
            result = true;
        } else {
            staticTaskMd5 = taskMd5;
        }
        return result;
    }

    private void refreshTask() throws SchedulerException {
        CopyOnWriteArrayList list = new CopyOnWriteArrayList(this.dataPacketDao.listObjectsByProperties((Map)queryParams));
        if (this.isEqualMd5(list)) {
            return;
        }
        CopyOnWriteArraySet triggerKeys = new CopyOnWriteArraySet(this.scheduler.getTriggerKeys(GroupMatcher.anyTriggerGroup()));
        for (DataPacket ll : list) {
            if ("".equals(ll.getTaskCron()) || ll.getTaskCron() == null) continue;
            int i = 0;
            for (TriggerKey tKey : triggerKeys) {
                if (!tKey.getName().equals(ll.getPacketId())) continue;
                ++i;
                CronTrigger quartzTrigger = (CronTrigger)this.scheduler.getTrigger(tKey);
                if (quartzTrigger.getCronExpression().equals(ll.getTaskCron())) break;
                QuartzJobUtils.createOrReplaceCronJob((Scheduler)this.scheduler, (String)ll.getPacketId(), (String)ll.getOwnGroup(), (String)"task", (String)ll.getTaskCron(), (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"taskExchange", ll}));
                break;
            }
            if (i != 0) continue;
            QuartzJobUtils.createOrReplaceCronJob((Scheduler)this.scheduler, (String)ll.getPacketId(), (String)ll.getOwnGroup(), (String)"task", (String)ll.getTaskCron(), (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"taskExchange", ll}));
        }
        for (TriggerKey tKey : triggerKeys) {
            boolean found = false;
            for (DataPacket ll : list) {
                TriggerKey triggerKey = TriggerKey.triggerKey((String)ll.getPacketId(), (String)ll.getOwnGroup());
                if (!tKey.equals((Object)triggerKey)) continue;
                found = true;
                break;
            }
            if (found) continue;
            QuartzJobUtils.deleteJob((Scheduler)this.scheduler, (String)tKey.getName(), (String)tKey.getGroup());
        }
    }

    @PostConstruct
    public void init() throws SchedulerException {
        OperationLogCenter.initOperationLogWriter((OperationLogWriter)this.operationLogWriter);
        QuartzJobUtils.registerJobType((String)"task", RunTaskJob.class);
        this.scheduler.start();
    }

    @Scheduled(fixedDelay=50000L)
    public void work() throws SchedulerException {
        this.refreshTask();
    }
}

