/*
 * Decompiled with CFR 0.152.
 */
package com.centit.locode.platform.service.impl;

import com.alibaba.fastjson2.JSONObject;
import com.centit.locode.platform.dao.I18nMessagesDao;
import com.centit.locode.platform.po.I18nMessages;
import com.centit.locode.platform.service.I18nMessagesService;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.database.utils.PageDesc;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class I18nMessagesServiceImpl
implements I18nMessagesService {
    @Value(value="${app.default.lang:zh_CN}")
    private String defaultLang;
    @Autowired
    private I18nMessagesDao i18nMessagesDao;

    @Override
    public List<I18nMessages> listI18nMessages(String osId) {
        return this.i18nMessagesDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"osId", osId}));
    }

    @Override
    public List<I18nMessages> listI18nMessages(Map<String, Object> filterMap, PageDesc pageDesc) {
        if (!filterMap.containsKey("osId")) {
            return null;
        }
        return this.i18nMessagesDao.listObjectsByProperties(filterMap, pageDesc);
    }

    @Override
    public I18nMessages getI18nMessages(String osId, String msgKey) {
        JSONObject id = new JSONObject();
        id.put((Object)"osId", (Object)osId);
        id.put((Object)"msgKey", (Object)msgKey);
        return (I18nMessages)this.i18nMessagesDao.getObjectById(id);
    }

    @Override
    public void saveI18nMessages(I18nMessages i18nMessages) {
        this.i18nMessagesDao.saveNewObject(i18nMessages);
    }

    @Override
    public void updateI18nMessages(I18nMessages i18nMessages) {
        this.i18nMessagesDao.updateObject(i18nMessages);
    }

    @Override
    public void deleteI18nMessages(String osId, String msgKey) {
        JSONObject id = new JSONObject();
        id.put((Object)"osId", (Object)osId);
        id.put((Object)"msgKey", (Object)msgKey);
        this.i18nMessagesDao.deleteObjectById(id);
    }

    @Override
    public Map<String, String> listI18nMessages(String osId, String lang) {
        List messages = this.i18nMessagesDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"osId", osId}));
        if (messages == null) {
            return null;
        }
        HashMap<String, String> msgMap = new HashMap<String, String>(messages.size() + 2);
        for (I18nMessages msg : messages) {
            String value = msg.getMsgValue().getString(lang);
            if (StringUtils.isBlank((CharSequence)value)) {
                if (lang.startsWith("zh_")) {
                    value = msg.getMsgValue().getString("zh_CN");
                }
                if (StringUtils.isBlank((CharSequence)value)) {
                    value = msg.getMsgValue().getString(this.defaultLang);
                }
            }
            msgMap.put(msg.getMsgKey(), value);
        }
        return msgMap;
    }
}

