/*
 * Decompiled with CFR 0.152.
 */
package com.centit.locode.platform.controller;

import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.locode.platform.po.Question;
import com.centit.locode.platform.service.QuestionService;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u7edf\u4e00\u95ee\u9898\u7ba1\u7406", tags={"\u7edf\u4e00\u95ee\u9898\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/problem"})
public class QuestionCotroller {
    @Autowired
    QuestionService questionService;

    @ApiOperation(value="\u65b0\u589e\u95ee\u9898\u4fe1\u606f")
    @PostMapping(value={"/addQuestion"})
    @WrapUpResponseBody
    public void createQuestion(@RequestBody Question question) {
        this.questionService.createQuestion(question);
    }

    @ApiOperation(value="\u7f16\u8f91\u95ee\u9898\u4fe1\u606f")
    @PutMapping(value={"/updateQuestion"})
    @WrapUpResponseBody
    public void updateQuestion(@RequestBody Question question) {
        this.questionService.updateQuestion(question);
    }

    @ApiOperation(value="\u5220\u9664\u95ee\u9898\u4fe1\u606f")
    @DeleteMapping(value={"/{questionId}"})
    @WrapUpResponseBody
    public void deleteQuestion(@PathVariable String questionId) {
        this.questionService.deleteQuestion(questionId);
    }

    @ApiOperation(value="\u67e5\u8be2\u95ee\u9898\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/listQuestion"})
    @WrapUpResponseBody
    public PageQueryResult<Question> listQuestion(HttpServletRequest request, PageDesc pageDesc) {
        List<Question> list = this.questionService.listQuestion(BaseController.collectRequestParameters((HttpServletRequest)request), pageDesc);
        return PageQueryResult.createResult(list, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u95ee\u9898\u4fe1\u606f")
    @GetMapping(value={"/{questionId}"})
    @WrapUpResponseBody
    public Question getQuestion(@PathVariable String questionId) {
        return this.questionService.getQuestion(questionId);
    }
}

