/*
 * Decompiled with CFR 0.152.
 */
package com.centit.locode.platform.controller;

import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.locode.platform.po.I18nMessages;
import com.centit.locode.platform.service.I18nMessagesService;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/i18n"})
@Api(tags={"\u56fd\u9645\u5316"}, value="\u79fb\u52a8\u7aef\u7248\u672c\u7ba1\u7406\u63a5\u53e3")
public class I18nMessagesController {
    @Autowired
    private I18nMessagesService i18nMessagesService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/list/{osId}"})
    @WrapUpResponseBody
    public PageQueryResult<I18nMessages> listMessages(@PathVariable String osId, HttpServletRequest request, PageDesc pageDesc) {
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        filterMap.put("osId", osId);
        List<I18nMessages> list = this.i18nMessagesService.listI18nMessages(filterMap, pageDesc);
        return PageQueryResult.createResult(list, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709")
    @GetMapping(value={"/listAll/{osId}"})
    @WrapUpResponseBody
    public List<I18nMessages> listMessagesByOsId(@PathVariable String osId) {
        return this.i18nMessagesService.listI18nMessages(osId);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u8bed\u8a00\u6240\u6709\u7684\u56fd\u9645\u5316\u4fe1\u606f")
    @GetMapping(value={"/listCurrentLang/{osId}"})
    @WrapUpResponseBody
    public Map<String, String> listCurrentLangMessagesByOsId(@PathVariable String osId, HttpServletRequest request) {
        String lang = WebOptUtils.getCurrentLang((HttpServletRequest)request);
        return this.i18nMessagesService.listI18nMessages(osId, lang);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e00\u6761\u56fd\u9645\u5316\u6761\u76ee")
    @GetMapping(value={"/get/{osId}/{msgKey}"})
    @WrapUpResponseBody
    public I18nMessages listMessagesByOsId(@PathVariable String osId, @PathVariable String msgKey) {
        return this.i18nMessagesService.getI18nMessages(osId, msgKey);
    }

    @ApiOperation(value="\u65b0\u589e\u56fd\u9645\u5316\u4fe1\u606f")
    @PostMapping
    @WrapUpResponseBody
    public void createI8nMessage(@RequestBody @Valid I18nMessages i18nMessages, HttpServletRequest request) {
        UserInfo userInfo = WebOptUtils.assertUserLogin((HttpServletRequest)request);
        i18nMessages.setUpdateUser(userInfo.getUserCode());
        this.i18nMessagesService.saveI18nMessages(i18nMessages);
    }

    @ApiOperation(value="\u4fee\u6539\u56fd\u9645\u5316\u4fe1\u606f")
    @PutMapping
    @WrapUpResponseBody
    public void updateI8nMessage(@RequestBody @Valid I18nMessages i18nMessages, HttpServletRequest request) {
        UserInfo userInfo = WebOptUtils.assertUserLogin((HttpServletRequest)request);
        i18nMessages.setUpdateUser(userInfo.getUserCode());
        this.i18nMessagesService.updateI18nMessages(i18nMessages);
    }

    @ApiOperation(value="\u5220\u9664\u56fd\u9645\u5316\u4fe1\u606f")
    @DeleteMapping(value={"/{osId}/{msgKey}"})
    @WrapUpResponseBody
    public void deleteI8nMessage(@PathVariable String osId, @PathVariable String msgKey) {
        this.i18nMessagesService.deleteI18nMessages(osId, msgKey);
    }
}

