/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.jlwater.controller;

import cn.com.syan.jce.provider.SyanSDFProvider;
import cn.com.syan.sdfapi.DCUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseSingleData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.jlwater.service.SignAppSession;
import com.centit.framework.jlwater.service.VerSignAppSession;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.security.CentitUserDetails;
import com.redshield.ebl.EblHsmEx;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Base64;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpResponseException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/jlwaterca"})
@Api(value="\u6c34\u52a1\u76f8\u5173\u63a5\u53e3", tags={"\u6c34\u52a1\u76f8\u5173\u63a5\u53e3"})
public class JlwaterCaPlugin
extends BaseController {
    @Value(value="${centit.sm4.iv:BD613820D53BCD45D8FB033EB44A63D4}")
    private String sm4Iv;
    protected static final Logger logger = LoggerFactory.getLogger(JlwaterCaPlugin.class);
    @Autowired
    private PlatformEnvironment platformEnvironment;
    @Autowired
    private SignAppSession signAppSession;
    @Autowired
    private VerSignAppSession verSignAppSession;

    @ApiOperation(value="\u6c34\u52a1\u96c6\u56e2\u5355\u70b9\u767b\u9646", notes="\u6c34\u52a1\u96c6\u56e2\u5355\u70b9\u767b\u9646")
    @GetMapping(value={"/login"})
    public String waterLogin(HttpServletRequest request, HttpServletResponse response) {
        String returnUrl = request.getParameter("returnUrl");
        String loginName = request.getHeader("oam_remote_user");
        if (null == loginName) {
            loginName = request.getParameter("testLoginName");
        }
        String errorMsg = "";
        if (StringUtils.isBlank((CharSequence)loginName)) {
            errorMsg = "oam_remote_user" + loginName + "\u4e0d\u5b58\u5728\uff01";
        } else {
            CentitUserDetails ud = this.platformEnvironment.loadUserDetailsByLoginName(loginName);
            if (null != ud) {
                SecurityContextHolder.getContext().setAuthentication((Authentication)ud);
            } else {
                errorMsg = "\u767b\u5f55\u540d" + loginName + "\u4e0d\u5b58\u5728\uff01";
            }
        }
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            String errorUrl = "redirect:redirecterror";
            try {
                errorUrl = errorUrl + "?msg=" + URLEncoder.encode(errorMsg, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error("URLEncoder\u5f02\u5e38", (Throwable)e);
            }
            return errorUrl;
        }
        String accessToken = request.getSession().getId();
        if (StringUtils.isNotBlank((CharSequence)returnUrl)) {
            if (returnUrl.contains("/A/")) {
                returnUrl = returnUrl.replace("/A/", "/#/");
            }
            returnUrl = returnUrl.contains("?") ? returnUrl + "&accessToken=" + accessToken : returnUrl + "?accessToken=" + accessToken;
        }
        response.setHeader("x-auth-token", accessToken);
        return "redirect:" + returnUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="sm4\u52a0\u5bc6", notes="sm4\u52a0\u5bc6")
    @GetMapping(value={"/sm4encrypt"})
    @WrapUpResponseBody
    public JSONObject sm4encrypt(String data, boolean isRandom, boolean isLoop) {
        JSONObject result = new JSONObject();
        if (data == null || data.isEmpty()) {
            result.put((Object)"sm4Cbc", (Object)"");
            result.put((Object)"random", (Object)"");
            return result;
        }
        EblHsmEx eblHsmEx = null;
        try {
            String random = isRandom ? JlwaterCaPlugin.genRandom(16) : this.sm4Iv;
            eblHsmEx = EblHsmEx.getHardInstance();
            LinkedList<String> dataArray = new LinkedList<String>();
            if (isLoop) {
                for (int i = 0; i < data.length(); ++i) {
                    dataArray.add(data.substring(i, Math.min(i + 1, data.length())));
                }
            } else {
                dataArray.add(data);
            }
            StringBuilder sm4Cbc = new StringBuilder();
            for (String chunk : dataArray) {
                byte[] dataByte = chunk.getBytes(StandardCharsets.UTF_8);
                sm4Cbc.append(eblHsmEx.encrypt(100, "SM4/CBC/PKCS5Padding", DCUtil.hexStr2Bytes((String)random), dataByte));
            }
            result.put((Object)"random", (Object)random);
            result.put((Object)"sm4Cbc", (Object)sm4Cbc.toString());
            JSONObject jSONObject = result;
            return jSONObject;
        }
        catch (Exception e) {
            logger.error("SM4\u52a0\u5bc6\u5931\u8d25: {}", (Object)data, (Object)e);
            result.put((Object)"sm4Cbc", (Object)data);
            result.put((Object)"random", (Object)"");
            JSONObject jSONObject = result;
            return jSONObject;
        }
        finally {
            if (eblHsmEx != null) {
                eblHsmEx.free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="sm4\u89e3\u5bc6", notes="sm4\u89e3\u5bc6")
    @GetMapping(value={"/sm4decrypt"})
    @WrapUpResponseBody
    public String sm4decrypt(String sm4Cbc, String random, boolean isLoop) {
        if (sm4Cbc == null || sm4Cbc.isEmpty()) {
            return "";
        }
        EblHsmEx eblHsmEx = null;
        try {
            eblHsmEx = EblHsmEx.getHardInstance();
            String string = this.getData(sm4Cbc, random, isLoop, eblHsmEx);
            return string;
        }
        catch (Exception e) {
            logger.error("SM4 \u89e3\u5bc6\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            String string = sm4Cbc;
            return string;
        }
        finally {
            if (eblHsmEx != null) {
                eblHsmEx.free();
            }
        }
    }

    private String getData(String sm4Cbc, String random, boolean isLoop, EblHsmEx eblHsmEx) {
        if (random == null || random.isEmpty()) {
            random = this.sm4Iv;
        }
        LinkedList<String> encryptedChunks = new LinkedList<String>();
        if (isLoop) {
            for (int i = 0; i < sm4Cbc.length(); i += 24) {
                encryptedChunks.add(sm4Cbc.substring(i, Math.min(i + 24, sm4Cbc.length())));
            }
        } else {
            encryptedChunks.add(sm4Cbc);
        }
        StringBuilder decryptedData = new StringBuilder();
        for (String chunk : encryptedChunks) {
            byte[] decryptedBytes = eblHsmEx.decrypt(100, "SM4/CBC/PKCS5Padding", DCUtil.hexStr2Bytes((String)random), chunk);
            decryptedData.append(new String(decryptedBytes, StandardCharsets.UTF_8));
        }
        return decryptedData.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="sm4\u6279\u91cf\u89e3\u5bc6", notes="sm4\u89e3\u5bc6")
    @PostMapping(value={"/sm4batchdecrypt"})
    @WrapUpResponseBody
    public JSONArray sm4batchDecrypt(@RequestBody JSONObject jsonObject) {
        JSONArray data = jsonObject.getJSONArray("data");
        JSONArray model = jsonObject.getJSONArray("model");
        if (data == null || model == null) {
            return data;
        }
        EblHsmEx eblHsmEx = null;
        try {
            eblHsmEx = EblHsmEx.getHardInstance();
            for (int i = 0; i < data.size(); ++i) {
                JSONObject item = data.getJSONObject(i);
                for (int j = 0; j < model.size(); ++j) {
                    JSONObject modelItem = model.getJSONObject(j);
                    String sm4CbcKey = modelItem.getString("sm4Cbc");
                    if (sm4CbcKey == null) continue;
                    String random = modelItem.getString("random");
                    boolean isLoop = modelItem.getBooleanValue("isLoop");
                    String encryptedData = item.getString(sm4CbcKey);
                    if (encryptedData == null || encryptedData.isEmpty()) continue;
                    String decryptedData = this.getData(encryptedData, random, isLoop, eblHsmEx);
                    item.put((Object)sm4CbcKey, (Object)decryptedData);
                }
            }
            JSONArray i = data;
            return i;
        }
        catch (Exception e) {
            logger.error("SM4 \u89e3\u5bc6\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            JSONArray jSONArray = data;
            return jSONArray;
        }
        finally {
            if (eblHsmEx != null) {
                eblHsmEx.free();
            }
        }
    }

    @ApiOperation(value="\u5916\u90e8\u5bc6\u94a5hmac", notes="\u5916\u90e8\u5bc6\u94a5hmac")
    @GetMapping(value={"/sm3encrypt"})
    @WrapUpResponseBody
    public JSONObject sm3encrypt(String data, boolean isRandom) {
        JSONObject result = new JSONObject();
        if (data == null || data.isEmpty()) {
            result.put((Object)"sm3Str", (Object)"");
            result.put((Object)"random", (Object)"");
            return result;
        }
        EblHsmEx eblHsmEx = null;
        try {
            String random = isRandom ? JlwaterCaPlugin.genRandom(16) : this.sm4Iv;
            eblHsmEx = EblHsmEx.getHardInstance();
            byte[] dataByte = data.getBytes(StandardCharsets.UTF_8);
            byte[] mac = eblHsmEx.hmacBytes(DCUtil.hexStr2Bytes((String)random), "HmacSM3", dataByte);
            result.put((Object)"sm3Str", (Object)Base64.getEncoder().encodeToString(mac));
            result.put((Object)"random", (Object)random);
            JSONObject jSONObject = result;
            return jSONObject;
        }
        catch (Exception e) {
            logger.error("SM3\u52a0\u5bc6\u5931\u8d25: {}", (Object)data, (Object)e);
            throw new RuntimeException("SM3\u52a0\u5bc6\u5931\u8d25", e);
        }
        finally {
            if (eblHsmEx != null) {
                eblHsmEx.free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u6570\u636e\u52a0\u5bc6\u5904\u7406", notes="\u63d0\u4f9b\u6570\u636e\u673a\u5bc6\u6027\u4fdd\u62a4\u7684\u52a0\u5bc6\u63a5\u53e3")
    @GetMapping(value={"/encryptAndMac"})
    @WrapUpResponseBody
    public JSONObject encryptAndMac(String data, boolean isRandom, boolean isLoop) {
        JSONObject result = new JSONObject();
        if (data == null || data.isEmpty() || "".equals(data.trim())) {
            result.put((Object)"sm4Cbc", (Object)"");
            result.put((Object)"sm3Str", (Object)"");
            return result;
        }
        EblHsmEx eblHsmEx = null;
        try {
            String random = isRandom ? JlwaterCaPlugin.genRandom(16) : this.sm4Iv;
            eblHsmEx = EblHsmEx.getHardInstance();
            LinkedList<String> dataArray = new LinkedList<String>();
            if (isLoop) {
                for (int i = 0; i < data.length(); ++i) {
                    dataArray.add(data.substring(i, Math.min(i + 1, data.length())));
                }
            } else {
                dataArray.add(data);
            }
            StringBuilder sm4Cbc = new StringBuilder();
            for (String chunk : dataArray) {
                byte[] dataByte = chunk.getBytes(StandardCharsets.UTF_8);
                sm4Cbc.append(eblHsmEx.encrypt(100, "SM4/CBC/PKCS5Padding", DCUtil.hexStr2Bytes((String)random), dataByte));
            }
            String sm3Str = eblHsmEx.hmac(DCUtil.hexStr2Bytes((String)random), "HmacSM3", sm4Cbc.toString().getBytes(StandardCharsets.UTF_8));
            result.put((Object)"sm4Cbc", (Object)sm4Cbc.toString());
            result.put((Object)"sm3Str", (Object)sm3Str);
            result.put((Object)"random", (Object)random);
        }
        catch (Exception e) {
            logger.error("\u52a0\u5bc6\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            result.put((Object)"sm4Cbc", (Object)data);
            result.put((Object)"sm3Str", (Object)"");
            result.put((Object)"random", (Object)"");
            JSONObject jSONObject = result;
            return jSONObject;
        }
        finally {
            if (eblHsmEx != null) {
                eblHsmEx.free();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u6570\u636e\u89e3\u5bc6\u4e0e\u5b8c\u6574\u6027\u6821\u9a8c", notes="\u89e3\u5bc6SM4\u52a0\u5bc6\u6570\u636e\u5e76\u9a8c\u8bc1HmacSM3\u5b8c\u6574\u6027")
    @GetMapping(value={"/decryptAndVerify"})
    @WrapUpResponseBody
    public JSONObject decryptAndVerify(String sm4Cbc, String sm3Str, String random, boolean isLoop) {
        String data = "";
        String dataSm3Str = "";
        JSONObject jsonObject = new JSONObject();
        if (sm4Cbc == null || sm4Cbc.isEmpty()) {
            jsonObject.put((Object)"data", (Object)data);
            if (sm3Str == null || sm3Str.isEmpty()) {
                jsonObject.put((Object)"isTampered", (Object)true);
            } else {
                jsonObject.put((Object)"isTampered", (Object)false);
            }
            return jsonObject;
        }
        EblHsmEx eblHsmEx = null;
        try {
            boolean isTampered;
            eblHsmEx = EblHsmEx.getHardInstance();
            if (random == null || random.isEmpty()) {
                random = this.sm4Iv;
            }
            boolean bl = isTampered = !(dataSm3Str = eblHsmEx.hmac(DCUtil.hexStr2Bytes((String)random), "HmacSM3", sm4Cbc.getBytes(StandardCharsets.UTF_8))).equals(sm3Str);
            if (isTampered) {
                jsonObject.put((Object)"data", (Object)sm4Cbc);
                jsonObject.put((Object)"sm3data", (Object)dataSm3Str);
                jsonObject.put((Object)"isTampered", (Object)isTampered);
            } else {
                LinkedList<String> encryptedChunks = new LinkedList<String>();
                if (isLoop) {
                    for (int i = 0; i < sm4Cbc.length(); i += 24) {
                        encryptedChunks.add(sm4Cbc.substring(i, Math.min(i + 24, sm4Cbc.length())));
                    }
                } else {
                    encryptedChunks.add(sm4Cbc);
                }
                StringBuilder decryptedData = new StringBuilder();
                for (String chunk : encryptedChunks) {
                    byte[] decryptedBytes = eblHsmEx.decrypt(100, "SM4/CBC/PKCS5Padding", DCUtil.hexStr2Bytes((String)random), chunk);
                    decryptedData.append(new String(decryptedBytes, StandardCharsets.UTF_8));
                }
                jsonObject.put((Object)"data", (Object)decryptedData.toString());
                jsonObject.put((Object)"isTampered", (Object)isTampered);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u5bc6\u6216\u6821\u9a8c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            jsonObject.put((Object)"data", (Object)data);
            JSONObject jSONObject = jsonObject;
            return jSONObject;
        }
        finally {
            if (eblHsmEx != null) {
                eblHsmEx.free();
            }
        }
        return jsonObject;
    }

    @ApiOperation(value="\u5b8c\u6574\u6027\u6821\u9a8c", notes="true\u5df2\u7be1\u6539")
    @GetMapping(value={"/verify"})
    @WrapUpResponseBody
    public boolean verify(String data, String sm3Str, String random) {
        if (data == null || data.isEmpty()) {
            return sm3Str == null || sm3Str.isEmpty();
        }
        EblHsmEx eblHsmEx = null;
        try {
            eblHsmEx = EblHsmEx.getHardInstance();
            if (random == null || random.isEmpty()) {
                random = this.sm4Iv;
            }
            byte[] dataByte = data.getBytes(StandardCharsets.UTF_8);
            String dataSm3Str = eblHsmEx.hmac(DCUtil.hexStr2Bytes((String)random), "HmacSM3", dataByte);
            boolean bl = !dataSm3Str.equals(sm3Str);
            return bl;
        }
        catch (Exception e) {
            logger.error("\u6821\u9a8c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u6821\u9a8c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38", e);
        }
        finally {
            if (eblHsmEx != null) {
                eblHsmEx.free();
            }
        }
    }

    private static String genRandom(int count) {
        SecureRandom random = null;
        try {
            Security.addProvider((Provider)new SyanSDFProvider());
            random = SecureRandom.getInstance("SDF", "SyanSDFProvider");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        return DCUtil.bytes2HexStr((byte[])random.generateSeed(count));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u83b7\u53d6\u968f\u673a\u6570", notes="\u83b7\u53d6\u968f\u673a\u6570")
    @GetMapping(value={"/genrand"})
    @WrapUpResponseBody
    public String genrand() {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = this.signAppSession.allocHttpClient();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"length", (Object)16);
            String string = this.signAppSession.formPost(httpClient, "/genrand", jsonObject);
            return string;
        }
        catch (Exception e) {
            logger.error("\u8bbf\u95ee\uff1a\u7b7e\u540d\u670d\u52a1\u62a5\u9519\uff1a" + e.getLocalizedMessage(), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (httpClient != null) {
                this.signAppSession.releaseHttpClient(httpClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u9a8c\u7b7e", notes="\u9a8c\u7b7e")
    @PostMapping(value={"/verSign"})
    @WrapUpResponseBody
    public ResponseData verSign(@RequestBody JSONObject jsonObject, HttpServletResponse response) {
        CloseableHttpClient httpClient = null;
        try {
            httpClient = this.verSignAppSession.allocHttpClient();
            String data = jsonObject.getString("data");
            data = Base64.getEncoder().encodeToString(data.getBytes(StandardCharsets.UTF_8));
            jsonObject.put((Object)"data", (Object)data);
            this.verSignAppSession.formPost(httpClient, "/vp1", jsonObject);
            ResponseSingleData responseSingleData = ResponseData.makeSuccessResponse((String)"\u9a8c\u7b7e\u6210\u529f");
            return responseSingleData;
        }
        catch (HttpResponseException e) {
            ResponseSingleData responseSingleData = ResponseData.makeErrorMessage((int)e.getStatusCode(), (String)e.getReasonPhrase());
            return responseSingleData;
        }
        catch (Exception e) {
            ResponseSingleData responseSingleData = ResponseData.makeErrorMessage((int)601, (String)e.getMessage());
            return responseSingleData;
        }
        finally {
            if (httpClient != null) {
                this.verSignAppSession.releaseHttpClient(httpClient);
            }
        }
    }
}

