/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.jlwater.controller;

import com.centit.framework.core.controller.BaseController;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.security.CentitUserDetails;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/jlwaterca"})
@Api(value="\u6c34\u52a1\u76f8\u5173\u63a5\u53e3", tags={"\u6c34\u52a1\u76f8\u5173\u63a5\u53e3"})
public class JlwaterCaPlugin
extends BaseController {
    @Autowired
    private PlatformEnvironment platformEnvironment;

    @ApiOperation(value="\u6c34\u52a1\u96c6\u56e2\u5355\u70b9\u767b\u9646", notes="\u6c34\u52a1\u96c6\u56e2\u5355\u70b9\u767b\u9646")
    @GetMapping(value={"/login"})
    public String waterLogin(HttpServletRequest request, HttpServletResponse response) {
        String returnUrl = request.getParameter("returnUrl");
        String loginName = request.getHeader("oam_remote_user");
        if (null == loginName) {
            loginName = request.getParameter("testLoginName");
        }
        String errorMsg = "";
        if (StringUtils.isBlank((CharSequence)loginName)) {
            errorMsg = "oam_remote_user" + loginName + "\u4e0d\u5b58\u5728\uff01";
        } else {
            CentitUserDetails ud = this.platformEnvironment.loadUserDetailsByLoginName(loginName);
            if (null != ud) {
                SecurityContextHolder.getContext().setAuthentication((Authentication)ud);
            } else {
                errorMsg = "\u767b\u5f55\u540d" + loginName + "\u4e0d\u5b58\u5728\uff01";
            }
        }
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            String errorUrl = "redirect:redirecterror";
            try {
                errorUrl = errorUrl + "?msg=" + URLEncoder.encode(errorMsg, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error("URLEncoder\u5f02\u5e38", (Throwable)e);
            }
            return errorUrl;
        }
        String accessToken = request.getSession().getId();
        if (StringUtils.isNotBlank((CharSequence)returnUrl)) {
            if (returnUrl.contains("/A/")) {
                returnUrl = returnUrl.replace("/A/", "/#/");
            }
            returnUrl = returnUrl.contains("?") ? returnUrl + "&accessToken=" + accessToken : returnUrl + "?accessToken=" + accessToken;
        }
        response.setHeader("x-auth-token", accessToken);
        return "redirect:" + returnUrl;
    }
}

