/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.basedata.UnitInfo;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.framework.model.basedata.UserUnit;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.system.service.SysUnitManager;
import com.centit.framework.system.service.SysUserManager;
import com.centit.framework.system.service.SysUserUnitManager;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.common.ParamName;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/userunit"})
@Api(value="\u7528\u6237\u673a\u6784\u5173\u8054\u64cd\u4f5c\uff0c\u6b64\u64cd\u4f5c\u662f\u53cc\u5411\u64cd\u4f5c\uff0c\u7528\u6237\u53ef\u5728\u7528\u6237\u7ba1\u7406\u4e2d\u65b0\u589e\u6216\u66f4\u65b0\u81ea\u8eab\u6240\u5728\u673a\u6784\uff0c\u673a\u6784\u53ef\u5728\u673a\u6784\u7ba1\u7406\u4e2d\u65b0\u589e\u6216\u66f4\u65b0\u673a\u6784\u5185\u7528\u6237\u3002", tags={"\u7528\u6237\u673a\u6784\u5173\u8054\u64cd\u4f5c\u63a5\u53e3"})
public class UserUnitController
extends BaseController {
    @Autowired
    @NotNull
    private SysUserUnitManager sysUserUnitManager;
    @Autowired
    @NotNull
    private SysUserManager sysUserManager;
    @Autowired
    @NotNull
    private SysUnitManager sysUnitManager;

    public String getOptId() {
        return "USERUNIT";
    }

    @ApiOperation(value="\u673a\u6784\u4eba\u5458\u6811\u5f62\u4fe1\u606f", notes="\u673a\u6784\u4eba\u5458\u6811\u5f62\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="state", value="A\u6216\u7a7a\uff0c\u8fd4\u56de\u6240\u6709\u673a\u6784\u4eba\u5458\u4fe1\u606f\u3002T\uff0c\u8fd4\u56de\u672a\u7981\u7528\u7684\u673a\u6784\u4eba\u5458\u4fe1\u606f", paramType="path", dataType="String")
    @RequestMapping(method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData list(String state, HttpServletRequest request) {
        HashMap<String, String> object;
        ArrayList listObjects = new ArrayList();
        if (StringUtils.isBlank((CharSequence)state)) {
            state = "A";
        }
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("topUnit", WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        if (StringUtils.isNotBlank((CharSequence)state) && !"A".equals(state)) {
            filterMap.put("isValid", state);
        }
        List users = this.sysUserManager.listObjects(filterMap);
        List units = this.sysUnitManager.listObjects(filterMap);
        for (UnitInfo unit : units) {
            object = new HashMap<String, String>();
            object.put("id", unit.getUnitCode());
            object.put("name", unit.getUnitName());
            object.put("pId", unit.getParentUnit());
            listObjects.add(object);
        }
        for (UserInfo user : users) {
            object = new HashMap();
            object.put("id", user.getUserCode());
            object.put("name", user.getUserName());
            object.put("pId", user.getPrimaryUnit());
            listObjects.add(object);
        }
        return ResponseData.makeResponseData(listObjects);
    }

    @ApiOperation(value="\u901a\u8fc7\u673a\u6784\u4ee3\u7801\u83b7\u53d6\u673a\u6784\u53ca\u5176\u5b50\u673a\u6784\u4e0b\u7528\u6237\u7ec4", notes="\u901a\u8fc7\u673a\u6784\u4ee3\u7801\u83b7\u53d6\u673a\u6784\u53ca\u5176\u5b50\u673a\u6784\u4e0b\u7528\u6237\u7ec4\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="unitCode", value="\u673a\u6784\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\u7684\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)})
    @RequestMapping(value={"/unitusers/{unitCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<UserUnit> listUsersByUnit(@PathVariable String unitCode, PageDesc pageDesc, HttpServletRequest request) {
        boolean withSubUnit = BooleanBaseOpt.castObjectToBoolean((Object)request.getParameter("withSubUnit"), (Boolean)false);
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        filterMap.put("unitCode", unitCode);
        filterMap.put("topUnit", WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        List listObjects = withSubUnit ? this.sysUserUnitManager.listSubUsersByUnitCode(unitCode, filterMap, pageDesc) : this.sysUserUnitManager.listObjects(filterMap, pageDesc);
        return PageQueryResult.createResultMapDict((Collection)listObjects, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u901a\u8fc7\u7528\u6237\u4ee3\u7801\u83b7\u53d6\u7528\u6237\u6240\u5728\u673a\u6784", notes="\u901a\u8fc7\u7528\u6237\u4ee3\u7801\u83b7\u53d6\u7528\u6237\u6240\u5728\u673a\u6784\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\u7684\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)})
    @RequestMapping(value={"/userunits/{userCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<Object> listUnitsByUser(@PathVariable String userCode, PageDesc pageDesc, HttpServletRequest request) {
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        filterMap.put("userCode", userCode);
        filterMap.put("topUnit", topUnit);
        List listObjects = this.sysUserUnitManager.listObjects(filterMap, pageDesc);
        JSONArray jsonArray = JSONArray.from((Object)listObjects);
        jsonArray = DictionaryMapUtils.mapJsonArray((JSONArray)jsonArray, (Class[])new Class[]{UserUnit.class});
        for (int i = 0; i < jsonArray.size(); ++i) {
            UnitInfo ui;
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String unitCode = jsonObject.getString("unitCode");
            if (unitCode == null || unitCode.isEmpty() || (ui = CodeRepositoryUtil.getUnitInfoByCode((String)topUnit, (String)unitCode)) == null) continue;
            String unitPath = ui.getUnitPath();
            jsonObject.put((Object)"unitPath", (Object)unitPath);
            jsonObject.put((Object)"unitPathName", (Object)CodeRepositoryUtil.transExpression((String)"unitCode", (String)unitPath));
        }
        return PageQueryResult.createJSONArrayResult((JSONArray)jsonArray, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6240\u5728\u673a\u6784\u5217\u8868\uff08\u5728\u5f53\u524d\u7528\u6237\u53ef\u89c1\u8303\u56f4\u5185\uff09")
    @ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801")
    @GetMapping(value={"/usercurrentunits/{userCode}"})
    @WrapUpResponseBody
    public PageQueryResult<UserUnit> listUserUnitsUnderUnitByUserCode(@PathVariable String userCode, PageDesc pageDesc, HttpServletRequest request) {
        String currentUnitCode = WebOptUtils.getCurrentUnitCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)currentUnitCode)) {
            throw new ObjectException(302, this.getI18nMessage("error.302.user_not_login", request, new Object[0]));
        }
        List userUnits = this.sysUserUnitManager.listUserUnitsUnderUnitByUserCode(userCode, currentUnitCode, pageDesc);
        return PageQueryResult.createResultMapDict((Collection)userUnits, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u673a\u6784\u5173\u8054\u5bf9\u8c61\u7684ID\u83b7\u53d6\u4e00\u6761\u7528\u6237\u673a\u6784\u5173\u8054\u4fe1\u606f", notes="\u6839\u636e\u7528\u6237\u673a\u6784\u5173\u8054\u5bf9\u8c61\u7684ID\u83b7\u53d6\u4e00\u6761\u7528\u6237\u673a\u6784\u5173\u8054\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="userUnitId", value="\u7528\u6237\u673a\u6784ID", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{userUnitId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getUserUnitById(@PathVariable String userUnitId, HttpServletRequest request) {
        UserUnit userUnit = this.sysUserUnitManager.getObjectById(userUnitId);
        if (null == userUnit) {
            return ResponseData.makeErrorMessage((int)604, (String)this.getI18nMessage("error.604.user_not_in_unit", request, new Object[0]));
        }
        return ResponseData.makeResponseData((Object)DictionaryMapUtils.objectToJSON((Object)userUnit));
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u4ee3\u7801\u548c\u673a\u6784\u4ee3\u7801\u83b7\u53d6\u4e00\u7ec4\u7528\u6237\u673a\u6784\u5173\u8054\u4fe1\u606f", notes="\u6839\u636e\u7528\u6237\u4ee3\u7801\u548c\u673a\u6784\u4ee3\u7801\u83b7\u53d6\u4e00\u7ec4\u7528\u6237\u673a\u6784\u5173\u8054\u4fe1\u606f\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="unitCode", value="\u673a\u6784\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/{unitCode}/{userCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getUserUnit(@PathVariable String unitCode, @PathVariable String userCode, HttpServletRequest request) {
        List userUnits = this.sysUserUnitManager.listObjectByUserUnit(userCode, unitCode);
        if (null == userUnits || userUnits.size() == 0) {
            return ResponseData.makeErrorMessage((int)604, (String)this.getI18nMessage("error.604.user_not_in_unit", request, new Object[0]));
        }
        return ResponseData.makeResponseData((Object)DictionaryMapUtils.objectsToJSONArray((Collection)userUnits));
    }

    @ApiOperation(value="\u521b\u5efa\u7528\u6237\u673a\u6784\u5173\u8054\u4fe1\u606f", notes="\u521b\u5efa\u7528\u6237\u673a\u6784\u5173\u8054\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="userUnit", value="json\u683c\u5f0f\u7684\u7528\u6237\u673a\u6784\u5173\u8054\u5bf9\u8c61\u4fe1\u606f", required=true, paramType="body", dataTypeClass=UserUnit.class)
    @RequestMapping(method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u65b0\u589e\u7528\u6237\u673a\u6784\u5173\u8054\u4fe1\u606f", tag="{userUnit.userUnitId}:{userUnit.userCode}:{userUnit.unitCode}")
    @WrapUpResponseBody
    public ResponseData create(@ParamName(value="userUnit") @Valid UserUnit userUnit, HttpServletRequest request) {
        UnitInfo unitInfo = this.sysUnitManager.getObjectById(userUnit.getUnitCode());
        if (!StringUtils.equals((CharSequence)userUnit.getTopUnit(), (CharSequence)unitInfo.getTopUnit())) {
            return ResponseData.makeErrorMessage((int)611, (String)this.getI18nMessage("error.611.data_invalid", request, new Object[]{userUnit.getTopUnit()}));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("unitCode", userUnit.getUnitCode());
        map.put("userRank", userUnit.getUserRank());
        map.put("userStation", userUnit.getUserStation());
        map.put("userCode", userUnit.getUserCode());
        List list = this.sysUserUnitManager.listObjects(map, new PageDesc());
        if (list != null && list.size() > 0) {
            return ResponseData.makeErrorMessage((int)702, (String)this.getI18nMessage("error.702.user_has_in_unit", request, new Object[0]));
        }
        userUnit.setCreator(WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        this.sysUserUnitManager.saveNewUserUnit(userUnit);
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u66f4\u65b0\u673a\u6784\u7528\u6237\u4fe1\u606f", notes="\u6839\u636e\u7528\u6237\u673a\u6784\u4ee3\u7801\u66f4\u65b0\u673a\u6784\u7528\u6237\u4fe1\u606f\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userUnitId", value="\u7528\u6237\u673a\u6784\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="userUnit", value="json\u683c\u5f0f\u7684\u7528\u6237\u673a\u6784\u5173\u8054\u5bf9\u8c61\u4fe1\u606f", required=true, paramType="body", dataTypeClass=UserUnit.class)})
    @RequestMapping(value={"/{userUnitId}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u7528\u6237\u673a\u6784\u5173\u8054\u4fe1\u606f", tag="userUnitId")
    @WrapUpResponseBody
    public ResponseData edit(@ParamName(value="userUnitId") @PathVariable String userUnitId, @Valid UserUnit userUnit, HttpServletRequest request) {
        userUnit.setUpdator(WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        UserUnit dbUserUnit = this.sysUserUnitManager.getObjectById(userUnitId);
        if (null == dbUserUnit) {
            return ResponseData.makeErrorMessage((int)604, (String)this.getI18nMessage("error.604.user_not_in_unit", request, new Object[0]));
        }
        this.sysUserUnitManager.updateUserUnit(userUnit);
        return ResponseData.makeResponseData((Object)userUnit);
    }

    @ApiOperation(value="\u5220\u9664\u7528\u6237\u673a\u6784\u5173\u8054\u4fe1\u606f", notes="\u6839\u636e\u7528\u6237\u673a\u6784\u4ee3\u7801 \u5220\u9664\u7528\u6237\u673a\u6784\u5173\u8054\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="userUnitId", value="\u7528\u6237\u673a\u6784\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/{userUnitId}"}, method={RequestMethod.DELETE})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u7528\u6237\u673a\u6784\u5173\u8054\u4fe1\u606f", tag="{userUnitId}")
    @WrapUpResponseBody
    public ResponseData delete(@ParamName(value="userUnitId") @PathVariable String userUnitId, HttpServletRequest request) {
        UserUnit dbUserUnit = this.sysUserUnitManager.getObjectById(userUnitId);
        if ("T".equals(dbUserUnit.getRelType()) || "O".equals(dbUserUnit.getRelType())) {
            return ResponseData.makeErrorMessage((int)703, (String)this.getI18nMessage("error.703.cannot_delete_userunit", request, new Object[0]));
        }
        this.sysUserUnitManager.deleteObject(dbUserUnit);
        return ResponseData.successResponse;
    }
}

