/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao;

import com.alibaba.fastjson2.JSONArray;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.model.basedata.FVUserRoles;
import com.centit.framework.model.basedata.UserRole;
import com.centit.framework.model.basedata.UserRoleId;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.orm.OrmDaoUtils;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Repository(value="userRoleDao")
public class UserRoleDao
extends BaseDaoImpl<UserRole, UserRoleId> {
    private static final String f_v_user_appoint_roles_sql = "select b.ROLE_CODE, b.ROLE_NAME, b.IS_VALID, 'D' as OBTAIN_TYPE, b.ROLE_TYPE,  b.UNIT_CODE, b.ROLE_DESC, a.USER_CODE, null as INHERITED_FROM, c.user_name, d.unit_name from F_USERROLE a join F_ROLEINFO b on (a.ROLE_CODE=b.ROLE_CODE) join f_userinfo c on a.user_code=c.user_code left join f_unitinfo d on c.primary_unit=d.unit_code where [:currentDateTime | a.OBTAIN_DATE <=  :currentDateTime and] (a.SECEDE_DATE is null [:currentDateTime | or a.SECEDE_DATE > :currentDateTime]) and b.IS_VALID='T' [:userCode | and a.USER_CODE = :userCode][:(startwith)roleName | and b.ROLE_NAME like :roleName][:roleCode | and a.ROLE_CODE = :roleCode]";
    private static final String f_v_user_inherited_roles_sql = "select b.ROLE_CODE, b.ROLE_NAME, b.IS_VALID, 'I' as OBTAIN_TYPE, b.ROLE_TYPE, b.UNIT_CODE, b.ROLE_DESC, c.USER_CODE, a.UNIT_CODE as INHERITED_FROM,d.user_name,e.unit_name from F_UNITROLE a join F_ROLEINFO b on (a.ROLE_CODE = b.ROLE_CODE) JOIN F_USERUNIT c on( a.UNIT_CODE = c.UNIT_CODE) join f_userinfo d on c.user_code=d.user_code join f_unitinfo e on a.unit_code=e.unit_code where [:currentDateTime | a.OBTAIN_DATE <=  :currentDateTime and] (a.SECEDE_DATE is null [:currentDateTime | or a.SECEDE_DATE > :currentDateTime]) and b.IS_VALID='T' [:userCode | and c.USER_CODE = :userCode][:(startwith)roleName | and b.ROLE_NAME like :roleName][:roleCode | and a.ROLE_CODE = :roleCode]";
    private static final String f_v_userroles_sql = "select b.ROLE_CODE, b.ROLE_NAME, b.IS_VALID, 'D' as OBTAIN_TYPE, b.ROLE_TYPE,  b.UNIT_CODE, b.ROLE_DESC, a.USER_CODE, null as INHERITED_FROM, c.user_name, d.unit_name from F_USERROLE a join F_ROLEINFO b on (a.ROLE_CODE=b.ROLE_CODE) join f_userinfo c on a.user_code=c.user_code left join f_unitinfo d on c.primary_unit=d.unit_code where [:currentDateTime | a.OBTAIN_DATE <=  :currentDateTime and] (a.SECEDE_DATE is null [:currentDateTime | or a.SECEDE_DATE > :currentDateTime]) and b.IS_VALID='T' [:userCode | and a.USER_CODE = :userCode][:(startwith)roleName | and b.ROLE_NAME like :roleName][:roleCode | and a.ROLE_CODE = :roleCode] union all select b.ROLE_CODE, b.ROLE_NAME, b.IS_VALID, 'I' as OBTAIN_TYPE, b.ROLE_TYPE, b.UNIT_CODE, b.ROLE_DESC, c.USER_CODE, a.UNIT_CODE as INHERITED_FROM,d.user_name,e.unit_name from F_UNITROLE a join F_ROLEINFO b on (a.ROLE_CODE = b.ROLE_CODE) JOIN F_USERUNIT c on( a.UNIT_CODE = c.UNIT_CODE) join f_userinfo d on c.user_code=d.user_code join f_unitinfo e on a.unit_code=e.unit_code where [:currentDateTime | a.OBTAIN_DATE <=  :currentDateTime and] (a.SECEDE_DATE is null [:currentDateTime | or a.SECEDE_DATE > :currentDateTime]) and b.IS_VALID='T' [:userCode | and c.USER_CODE = :userCode][:(startwith)roleName | and b.ROLE_NAME like :roleName][:roleCode | and a.ROLE_CODE = :roleCode]";
    private static final String f_v_topunit_user_role = "select b.ROLE_CODE, b.ROLE_NAME, b.IS_VALID, 'D' as OBTAIN_TYPE, b.ROLE_TYPE,  b.UNIT_CODE, b.ROLE_DESC, a.USER_CODE, null as INHERITED_FROM, c.user_name, d.unit_name from F_USERROLE a join F_ROLEINFO b on (a.ROLE_CODE=b.ROLE_CODE) join f_userinfo c on a.user_code=c.user_code left join f_unitinfo d on c.primary_unit=d.unit_code where a.USER_CODE = :userCode and a.OBTAIN_DATE <= :currentDateTime and  (a.SECEDE_DATE is null  or a.SECEDE_DATE > :currentDateTime) and b.IS_VALID='T'  and (b.UNIT_CODE = 'system' or b.UNIT_CODE = :unitCode)";
    private static final String f_v_topunit_role_user = "select b.ROLE_CODE, b.ROLE_NAME, b.IS_VALID, 'D' as OBTAIN_TYPE, b.ROLE_TYPE,  b.UNIT_CODE, b.ROLE_DESC, a.USER_CODE, null as INHERITED_FROM,c.user_name, d.unit_name from F_USERROLE a join F_ROLEINFO b on (a.ROLE_CODE=b.ROLE_CODE) join f_userinfo c on a.user_code=c.user_code left join f_unitinfo d on c.primary_unit=d.unit_code where a.ROLE_CODE = :roleCode and a.OBTAIN_DATE <= :currentDateTime and  (a.SECEDE_DATE is null  or a.SECEDE_DATE > :currentDateTime) and b.IS_VALID='T'  and (b.ROLE_TYPE = 'G' or b.UNIT_CODE = :unitCode)";
    private static final String user_system_power_map_sql = "select distinct oi.TOP_OPT_ID from f_userrole ur join f_roleinfo fr on (ur.ROLE_CODE=fr.ROLE_CODE)  join f_rolepower rp on (ur.ROLE_CODE = rp.ROLE_CODE)  join f_optdef fo on (rp.OPT_CODE = fo.OPT_CODE)  join f_optinfo oi on (fo.OPT_ID = oi.OPT_ID) where ur.USER_CODE = ? and fr.UNIT_CODE = ? ";
    private static final String check_user_system_power_sql = "select count(oi.TOP_OPT_ID) as hasPowers from f_userrole ur  join f_rolepower rp on (ur.ROLE_CODE = rp.ROLE_CODE)  join f_optdef fo on (rp.OPT_CODE = fo.OPT_CODE)  join f_optinfo oi on (fo.OPT_ID = oi.OPT_ID)  where ur.USER_CODE = ? and oi.TOP_OPT_ID = ? ";

    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("roleCode", "EQUAL");
        filterField.put("userCode", "EQUAL");
        filterField.put("roleName", "LIKE");
        filterField.put("roleUnitCode", "ROLE_CODE in (select ro.ROLE_CODE from f_roleinfo ro where (ro.ROLE_TYPE = 'G' or ro.UNIT_CODE = :roleUnitCode))");
        filterField.put("unitCode", "USER_CODE in (select uu.USER_CODE from F_USERUNIT uu where uu.UNIT_CODE = :unitCode)");
        filterField.put("topUnit", "ROLE_CODE in (select ro.ROLE_CODE from f_roleinfo ro where ROLE_TYPE = 'G' or ro.UNIT_CODE = :topUnit)");
        filterField.put("userCode_isValid", "userCode in (select us.USER_CODE from f_userinfo us where us.IS_VALID = :userCode_isValid)");
        filterField.put("(like)userName", "userCode in (select us.USER_CODE from f_userinfo us where (us.USER_NAME like :userName or us.LOGIN_NAME like :userName))");
        filterField.put("(STARTWITH)unitPath", "userCode in (select us.USER_CODE from f_userunit us where us.UNIT_CODE in (select un.UNIT_CODE from f_unitinfo un where un.UNIT_PATH like :unitPath))");
        filterField.put("userValid", "userCode in (select us.USER_CODE from f_userinfo us where us.IS_VALID = :userValid)");
        filterField.put("roleValid", "roleCode in (select us.ROLE_CODE from f_roleinfo us where us.IS_VALID = :roleValid)");
        return filterField;
    }

    @Transactional
    public List<UserRole> listUserRoles(String userCode) {
        return super.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userCode}));
    }

    @Transactional
    public List<UserRole> listRoleUsers(String roleCode) {
        return super.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"roleCode", roleCode}));
    }

    @Transactional
    public void deleteObjectById(UserRoleId id) {
        super.deleteObjectById((Object)id);
    }

    @Transactional
    public UserRole getObjectById(UserRoleId id) {
        return (UserRole)super.getObjectById((Object)id);
    }

    @Transactional
    public void deleteByRoleId(String roid) {
        super.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"roleCode", roid}));
    }

    @Transactional
    public void deleteByUserId(String usid) {
        super.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", usid}));
    }

    @Transactional
    public List<FVUserRoles> listUserRolesByUserCode(String userCode) {
        Map map = CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userCode, "currentDateTime", DatetimeOpt.currentUtilDate()});
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)f_v_userroles_sql, (Object)map);
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.queryObjectsByNamedParamsSql((Connection)conn, (String)qap.getQuery(), (Map)qap.getParams(), FVUserRoles.class));
    }

    @Transactional
    public List<FVUserRoles> listRoleUsersByRoleCode(String roleCode) {
        Map map = CollectionsOpt.createHashMap((Object[])new Object[]{"roleCode", roleCode, "currentDateTime", DatetimeOpt.currentUtilDate()});
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)f_v_userroles_sql, (Object)map);
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.queryObjectsByNamedParamsSql((Connection)conn, (String)qap.getQuery(), (Map)qap.getParams(), FVUserRoles.class));
    }

    @Transactional
    public List<FVUserRoles> listUserRolesByTopUnit(String topUnit, String userCode) {
        Map map = CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userCode, "currentDateTime", DatetimeOpt.currentUtilDate(), "unitCode", topUnit});
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.queryObjectsByNamedParamsSql((Connection)conn, (String)f_v_topunit_user_role, (Map)map, FVUserRoles.class));
    }

    @Transactional
    public List<FVUserRoles> listRoleUsersByTopUnit(String topUnit, String roleCode) {
        Map map = CollectionsOpt.createHashMap((Object[])new Object[]{"roleCode", roleCode, "currentDateTime", DatetimeOpt.currentUtilDate(), "unitCode", topUnit});
        return (List)this.jdbcTemplate.execute(conn -> OrmDaoUtils.queryObjectsByNamedParamsSql((Connection)conn, (String)f_v_topunit_role_user, (Map)map, FVUserRoles.class));
    }

    @Transactional
    public int pageCountUserRole(Map<String, Object> filterDescMap) {
        String sql = "select count(*) as cnt from (";
        String obtainType = StringBaseOpt.castObjectToString((Object)filterDescMap.get("obtainType"));
        sql = "D".equals(obtainType) ? sql + f_v_user_appoint_roles_sql + ") u " : ("I".equals(obtainType) ? sql + f_v_user_inherited_roles_sql + ") u " : sql + f_v_userroles_sql + ") u ");
        filterDescMap.put("currentDateTime", DatetimeOpt.currentUtilDate());
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)sql, filterDescMap);
        return (Integer)this.jdbcTemplate.execute(conn -> OrmDaoUtils.fetchObjectsCount((Connection)conn, (String)qap.getQuery(), (Map)qap.getParams()));
    }

    @Transactional
    public JSONArray pageQueryUserRole(Map<String, Object> filterMap, PageDesc pageDesc) {
        String obtainType = StringBaseOpt.castObjectToString((Object)filterMap.get("obtainType"));
        String querySql = "D".equals(obtainType) ? f_v_user_appoint_roles_sql : ("I".equals(obtainType) ? f_v_user_inherited_roles_sql : f_v_userroles_sql);
        filterMap.put("currentDateTime", DatetimeOpt.currentUtilDate());
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)querySql, filterMap);
        return DatabaseOptUtils.listObjectsByNamedSqlAsJson((BaseDaoImpl)this, (String)qap.getQuery(), (Map)qap.getParams(), (PageDesc)pageDesc);
    }

    @Transactional
    public void deleteByRoleCodeAndUserCode(String roleCode, String userCode) {
        super.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userCode, "roleCode", roleCode}));
    }

    @Transactional
    public UserRole getValidUserRole(String userCode, String rolecode) {
        String sql = "select u.USER_CODE, u.ROLE_CODE, u.OBTAIN_DATE, u.CHANGE_DESC, u.CREATE_DATE, u.CREATOR, u.UPDATOR, u.UPDATE_DATE from F_USERROLE u where u.id.userCode=:userCode and u.id.roleCode = :roleCode ORDER BY obtainDate";
        List urlt = this.listObjectsBySql(sql, CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userCode, "roleCode", rolecode}));
        if (CollectionUtils.isEmpty((Collection)urlt)) {
            return null;
        }
        return (UserRole)urlt.get(0);
    }

    @Transactional
    public void updateUserRole(UserRole userRole) {
        super.updateObject((Serializable)userRole);
    }

    @Transactional
    public void mergeUserRole(UserRole dbUserRole) {
        super.mergeObject((Serializable)dbUserRole);
    }

    public List<String> listUserCanAccessSystem(String topUnit, String userCode) {
        List objects = DatabaseOptUtils.listObjectsBySql((BaseDaoImpl)this, (String)user_system_power_map_sql, (Object[])new Object[]{userCode, topUnit});
        ArrayList<String> systemCodes = new ArrayList<String>();
        for (Object[] obj : objects) {
            if (obj == null || obj.length <= 0) continue;
            systemCodes.add(StringBaseOpt.castObjectToString((Object)obj[0]));
        }
        return systemCodes;
    }

    public boolean checkUserSystemPower(String osId, String userCode) {
        Object obj = DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)check_user_system_power_sql, (Object[])new Object[]{userCode, osId});
        return NumberBaseOpt.castObjectToInteger((Object)obj, (Integer)0) > 0;
    }
}

