/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.model.basedata.UnitRole;
import com.centit.framework.model.basedata.UnitRoleId;
import com.centit.support.algorithm.CollectionsOpt;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="unitRoleDao")
public class UnitRoleDao
extends BaseDaoImpl<UnitRole, UnitRoleId> {
    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("roleCode", "ROLE_CODE = :roleCode");
        filterField.put("unitCode", "UNIT_CODE = :unitCode");
        filterField.put("(StartWith)unitPathPrefix", "UNIT_CODE in (select UNIT_CODE from f_unitinfo where UNIT_PATH like :unitPathPrefix)");
        filterField.put("currentUnitCode", "ROLE_CODE in (select ROLE_CODE from f_roleinfo where UNIT_CODE = :currentUnitCode)");
        filterField.put("unitValid", "unitCode in (select UNIT_CODE from f_unitinfo where IS_VALID = :unitValid)");
        filterField.put("roleValid", "roleCode in (select ROLE_CODE from f_roleinfo where IS_VALID = :roleValid)");
        return filterField;
    }

    @Transactional
    public void updateUnitRole(UnitRole dbUnitRole) {
        super.updateObject((Serializable)dbUnitRole);
    }

    @Transactional
    public void mergeUnitRole(UnitRole dbUnitRole) {
        super.mergeObject((Serializable)dbUnitRole);
    }

    @Transactional
    public void deleteUnitRole(UnitRole dbUnitRole) {
        super.deleteObject((Serializable)dbUnitRole);
    }

    @Transactional
    public void deleteUnitRoleById(UnitRoleId id) {
        super.deleteObjectById((Object)id);
    }

    @Transactional
    public UnitRole getUnitRoleById(UnitRoleId id) {
        return (UnitRole)super.getObjectById((Object)id);
    }

    @Transactional
    public List<UnitRole> listUnitRolesByUnitCode(String unitCode) {
        return super.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"unitCode", unitCode}));
    }

    @Transactional
    public List<UnitRole> listUnitRolesByRoleCode(String roleCode) {
        return super.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"roleCode", roleCode}));
    }
}

