/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.model.basedata.OptMethod;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.database.orm.OrmDaoUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="optMethodDao")
public class OptMethodDao
extends BaseDaoImpl<OptMethod, String> {
    public String getNextOptCode() {
        return UuidOpt.getUuidAsString22();
    }

    public List<OptMethod> listObjectsAll() {
        return super.listObjects();
    }

    public OptMethod getObjectById(String optCode) {
        return (OptMethod)super.getObjectById((Object)optCode);
    }

    public void deleteOptMethodById(String optCode) {
        super.deleteObjectById((Object)optCode);
    }

    @Transactional
    public List<OptMethod> listOptMethodByOptID(String sOptID) {
        return this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"optId", sOptID}));
    }

    @Transactional
    public List<OptMethod> listOptMethodByRoleCode(String roleCode) {
        return this.listObjectsByFilter(" WHERE OPT_CODE in (select rp.OPT_CODE from F_ROLEPOWER rp where rp.ROLE_CODE = ?) order by OPT_ID", new Object[]{roleCode});
    }

    @Transactional
    public void deleteOptMethodsByOptID(String sOptID) {
        this.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"optId", sOptID}));
    }

    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("optId", "EQUAL");
        filterField.put("optCode", "EQUAL");
        filterField.put("isInWorkflow", "EQUAL");
        filterField.put("optReq", "EQUAL");
        filterField.put("optMethod", "EQUAL");
        filterField.put("optName", "LIKE");
        return filterField;
    }

    @Transactional
    public List<OptMethod> listAllOptMethodByUnit(String topUnit) {
        String sql = "select o.* from F_OPTDEF o join F_OPTINFO a on ( o.OPT_ID = a.OPT_ID )join F_OS_INFO b on(a.TOP_OPT_ID=b.os_id) where b.TOP_UNIT = ?";
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)sql, (Object[])new Object[]{topUnit}, OptMethod.class));
    }

    public List<OptMethod> listPublicOptMethodByUnit(String topUnit) {
        String sql = "select o.* from F_OPTDEF o join F_OPTINFO a on ( o.OPT_ID = a.OPT_ID ) join f_rolepower c on o.opt_code=c.opt_code and c.role_code='public' join F_OS_INFO b on(a.TOP_OPT_ID=b.REL_OPT_ID) where b.TOP_UNIT = ?";
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.queryObjectsByParamsSql((Connection)conn, (String)sql, (Object[])new Object[]{topUnit}, OptMethod.class));
    }

    public List<OptMethod> listUserOptMethodByRoleCode(String[] roleCodes) {
        String sql = "select o.* from F_OPTDEF o join F_OPTINFO a on ( o.OPT_ID = a.OPT_ID ) join f_rolepower c on o.opt_code=c.opt_code where c.role_code in (:roleCodes)";
        return (List)this.getJdbcTemplate().execute(conn -> OrmDaoUtils.queryObjectsByNamedParamsSql((Connection)conn, (String)sql, (Map)CollectionsOpt.createHashMap((Object[])new Object[]{"roleCodes", roleCodes}), OptMethod.class));
    }

    public void updateOptMethod(OptMethod optMethod) {
        super.updateObject((Serializable)optMethod);
    }

    public int[] updateOptIdByOptCodes(final String optId, final List<String> optCodes) {
        String sql = "UPDATE f_optdef SET OPT_ID=? WHERE OPT_CODE = ? ";
        return this.jdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement preparedStatement, int i) throws SQLException {
                preparedStatement.setString(1, optId);
                preparedStatement.setString(2, (String)optCodes.get(i));
            }

            public int getBatchSize() {
                return optCodes.size();
            }
        });
    }
}

