/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.model.basedata.OptMethod;
import com.centit.framework.system.dao.OptMethodDao;
import com.centit.framework.system.dao.RolePowerDao;
import com.centit.framework.system.service.OptMethodManager;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="optMethodManager")
@Transactional
public class OptMethodManagerImpl
implements OptMethodManager {
    @Autowired
    @NotNull
    protected OptMethodDao optMethodDao;
    @Autowired
    @NotNull
    protected RolePowerDao rolePowerDao;

    @Override
    public void updateOptMethod(OptMethod o) {
        this.optMethodDao.updateOptMethod(o);
        CodeRepositoryCache.evictCache((String)"OptMethod");
    }

    @Override
    public List<OptMethod> listOptMethodByOptID(String sOptID) {
        return this.optMethodDao.listOptMethodByOptID(sOptID);
    }

    @Override
    public String getNextOptCode() {
        return this.optMethodDao.getNextOptCode();
    }

    @Override
    public List<OptMethod> listObjects() {
        return this.optMethodDao.listObjectsAll();
    }

    @Override
    public OptMethod getObjectById(String optCode) {
        return this.optMethodDao.getObjectById(optCode);
    }

    @Override
    public void deleteObjectById(String optCode) {
        this.optMethodDao.deleteOptMethodById(optCode);
        this.rolePowerDao.deleteRolePowersByOptCode(optCode);
        CodeRepositoryCache.evictCache((String)"OptMethod");
    }

    @Override
    public String saveNewObject(OptMethod optMethod) {
        this.optMethodDao.saveNewObject((Serializable)optMethod);
        CodeRepositoryCache.evictCache((String)"OptMethod");
        return optMethod.getOptCode();
    }

    @Override
    public List<OptMethod> listAllOptMethodByUnit(String topUnit) {
        return this.optMethodDao.listAllOptMethodByUnit(topUnit);
    }
}

