/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.centit.framework.components.CodeRepositoryCache;
import com.centit.framework.model.basedata.FVUserOptList;
import com.centit.framework.model.basedata.FVUserRoles;
import com.centit.framework.model.basedata.OptMethod;
import com.centit.framework.model.basedata.RoleInfo;
import com.centit.framework.model.basedata.UnitInfo;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.framework.model.basedata.UserRole;
import com.centit.framework.model.basedata.UserUnit;
import com.centit.framework.model.security.CentitPasswordEncoder;
import com.centit.framework.system.dao.UnitInfoDao;
import com.centit.framework.system.dao.UserInfoDao;
import com.centit.framework.system.dao.UserRoleDao;
import com.centit.framework.system.dao.UserUnitDao;
import com.centit.framework.system.service.SysUserManager;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.compiler.Pretreatment;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.security.SecurityOptUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysUserManager")
public class SysUserManagerImpl
implements SysUserManager {
    public static Logger logger = LoggerFactory.getLogger(SysUserManagerImpl.class);
    @Autowired
    @NotNull
    private CentitPasswordEncoder passwordEncoder;
    @Autowired
    @NotNull
    private UserUnitDao userUnitDao;
    @Autowired
    @NotNull
    private UserRoleDao userRoleDao;
    @Autowired
    protected UserInfoDao userInfoDao;
    @Autowired
    private UnitInfoDao unitInfoDao;
    @Value(value="${login.password.minLength:8}")
    private int passwordMinLength;
    @Value(value="${login.password.strength:3}")
    private int passwordStrength;
    @Value(value="${framework.password.default.generator:}")
    protected String defaultPassWorkFormat;
    @Value(value="${framework.password.force.change:true}")
    protected Boolean passwordForceChange;
    @Value(value="${framework.userinfo.id.generator:}")
    protected String userIdFormat;

    private String getDefaultPassword(String userCode) {
        String rawPass = UuidOpt.randomString((int)this.passwordMinLength);
        if (StringUtils.isNotBlank((CharSequence)this.defaultPassWorkFormat)) {
            rawPass = Pretreatment.mapTemplateString((String)this.defaultPassWorkFormat, (Object)userCode);
        }
        return this.passwordEncoder.createPassword(rawPass, (Object)userCode);
    }

    @Override
    @Transactional
    public List<RoleInfo> listUserValidRoles(String userCode) {
        ArrayList<RoleInfo> roles = new ArrayList<RoleInfo>();
        roles.add(new RoleInfo("public", "general public", "G", "G", "T", "general public"));
        List<FVUserRoles> ls = this.userRoleDao.listUserRolesByUserCode(userCode);
        if (ls != null) {
            for (FVUserRoles l : ls) {
                RoleInfo roleInfo = new RoleInfo();
                BeanUtils.copyProperties((Object)l, (Object)roleInfo);
                roles.add(roleInfo);
            }
        }
        return roles;
    }

    @Override
    @Transactional
    public void setNewPassword(String userCode, String oldPassword, String newPassword) {
        UserInfo user = this.userInfoDao.getUserByCode(userCode);
        if (!this.passwordEncoder.isPasswordValid(user.getUserPin(), oldPassword, (Object)user.getUserCode())) {
            throw new ObjectException("\u65e7\u5bc6\u7801\u4e0d\u6b63\u786e\uff01");
        }
        if (user.getUserPin().equals(this.passwordEncoder.encodePassword(newPassword, (Object)user.getUserCode()))) {
            throw new ObjectException("\u65b0\u5bc6\u7801\u548c\u65e7\u5bc6\u7801\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u65b0\u5bc6\u7801\uff01");
        }
        if (CentitPasswordEncoder.checkPasswordStrength((String)newPassword, (int)this.passwordMinLength) < this.passwordStrength) {
            throw new ObjectException("\u65b0\u7684\u5bc6\u7801\u5f3a\u5ea6\u592a\u4f4e\uff0c\u8bf7\u8f93\u5165\u7b26\u5408\u8981\u6c42\u7684\u5bc6\u7801\uff01");
        }
        user.setUserPin(this.passwordEncoder.encodePassword(newPassword, (Object)user.getUserCode()));
        this.userInfoDao.updateUser(user);
    }

    @Override
    @Transactional
    public void forceSetPassword(String userCode, String newPassword) {
        if (CentitPasswordEncoder.checkPasswordStrength((String)newPassword, (int)this.passwordMinLength) < this.passwordStrength) {
            throw new ObjectException("\u65b0\u7684\u5bc6\u7801\u5f3a\u5ea6\u592a\u4f4e\uff0c\u8bf7\u8f93\u5165\u7b26\u5408\u8981\u6c42\u7684\u5bc6\u7801\uff01");
        }
        this.forceSetPasswordPermissionCheck(userCode);
        UserInfo user = this.userInfoDao.getUserByCode(userCode);
        user.setUserPin(this.passwordEncoder.encodePassword(newPassword, (Object)user.getUserCode()));
        user.setPwdExpiredTime(DatetimeOpt.addDays((Date)DatetimeOpt.currentUtilDate(), (int)-1));
        this.userInfoDao.updateUser(user);
    }

    private void forceSetPasswordPermissionCheck(String userCode) {
        UserInfo userInfo = this.userInfoDao.getUserByCode(userCode);
        if (null == userInfo) {
            throw new ObjectException(703, "\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728!");
        }
        if (!this.passwordForceChange.booleanValue() && !StringUtils.isAllBlank((CharSequence[])new CharSequence[]{userInfo.getRegCellPhone(), userInfo.getRegEmail()})) {
            throw new ObjectException(703, "\u8be5\u7528\u6237\u4e0d\u5141\u8bb8\u91cd\u7f6e\u5bc6\u7801");
        }
    }

    @Override
    @Transactional
    public boolean checkIfUserExists(UserInfo user) {
        return this.isLoginNameExist(user.getUserCode(), user.getLoginName());
    }

    @Override
    @Transactional
    public boolean isLoginNameExist(String userCode, String loginName) {
        return this.userInfoDao.isLoginNameExist(userCode, loginName) > 0;
    }

    @Override
    @Transactional
    public boolean isCellPhoneExist(String userCode, String regPhone) {
        return this.userInfoDao.isCellPhoneExist(userCode, regPhone) > 0;
    }

    @Override
    @Transactional
    public boolean isEmailExist(String userCode, String regEmail) {
        return this.userInfoDao.isEmailExist(userCode, regEmail) > 0;
    }

    @Override
    @Transactional
    public boolean isAnyOneExist(String userCode, String loginName, String regPhone, String regEmail) {
        return this.userInfoDao.isAnyOneExist(userCode, loginName, regPhone, regEmail) > 0;
    }

    @Override
    @Transactional
    public void saveNewUserInfo(UserInfo userInfo, UserUnit userUnit) {
        Object[] unitCodeArray;
        String userCode = userInfo.getUserCode();
        if (StringUtils.isBlank((CharSequence)userCode)) {
            userCode = "U" + UuidOpt.randomString((int)11);
            userInfo.setUserCode(userCode);
        }
        String userPwd = SecurityOptUtils.decodeSecurityString((String)userInfo.getUserPwd());
        userInfo.setUserPin(this.passwordEncoder.createPassword(userPwd, (Object)userCode));
        userInfo.setPwdExpiredTime(DatetimeOpt.addDays((Date)DatetimeOpt.currentUtilDate(), (int)-1));
        userInfo.setUserPwd(null);
        UnitInfo unitInfo = this.unitInfoDao.getObjectById(userInfo.getPrimaryUnit());
        if (null != unitInfo && StringUtils.isNotBlank((CharSequence)unitInfo.getTopUnit())) {
            userInfo.setTopUnit(unitInfo.getTopUnit());
        }
        if (null != unitInfo && StringUtils.isBlank((CharSequence)userInfo.getTopUnit()) && StringUtils.isNotBlank((CharSequence)unitInfo.getUnitPath()) && ArrayUtils.isNotEmpty((Object[])(unitCodeArray = unitInfo.getUnitPath().split("/"))) && unitCodeArray.length > 1) {
            userInfo.setTopUnit((String)unitCodeArray[1]);
        }
        this.userInfoDao.saveUserInfo(userInfo);
        userUnit.setUserUnitId(this.userUnitDao.getNextKey());
        userUnit.setUserCode(userInfo.getUserCode());
        userUnit.setUnitCode(userInfo.getPrimaryUnit());
        userUnit.setRelType("T");
        userUnit.setTopUnit(userInfo.getTopUnit());
        this.userUnitDao.saveNewObject((Serializable)userUnit);
        if (null != userInfo.getUserRoles()) {
            for (UserRole ur : userInfo.getUserRoles()) {
                this.userRoleDao.saveNewObject((Serializable)ur);
            }
        }
        CodeRepositoryCache.evictCache((String)"UserInfo");
        CodeRepositoryCache.evictCache((String)"UserUnit");
    }

    @Override
    @Transactional
    public void updateUserInfo(UserInfo userinfo) {
        this.userInfoDao.updateUser(userinfo);
        CodeRepositoryCache.evictCache((String)"UserInfo");
    }

    @Override
    @Transactional
    public void updateUserProperities(UserInfo userinfo) {
        this.userInfoDao.updateUser(userinfo);
        CodeRepositoryCache.evictCache((String)"UserInfo");
    }

    @Override
    @Transactional
    public void deleteUserInfo(String userCode) {
        this.userUnitDao.deleteUserUnitByUser(userCode);
        this.userRoleDao.deleteByUserId(userCode);
        this.userInfoDao.deleteObjectById(userCode);
        CodeRepositoryCache.evictCache((String)"UserInfo");
        CodeRepositoryCache.evictCache((String)"UserUnit");
    }

    @Override
    @Transactional
    public UserInfo loadUserByLoginname(String userCode) {
        return this.userInfoDao.getUserByLoginName(userCode);
    }

    @Override
    @Transactional
    public boolean checkUserPassword(String userCode, String oldPassword) {
        UserInfo user = this.userInfoDao.getUserByCode(userCode);
        return this.passwordEncoder.isPasswordValid(user.getUserPin(), oldPassword, (Object)user.getUserCode());
    }

    @Override
    @Transactional
    public List<UserInfo> listObjects(Map<String, Object> filterMap) {
        return this.userInfoDao.listObjects(filterMap);
    }

    @Override
    @Transactional
    public List<UserInfo> listObjects(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.userInfoDao.listObjectsByProperties(filterMap, pageDesc);
    }

    @Override
    public JSONArray listObjectsByUnit(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.userInfoDao.listObjectsByUnit(filterMap, pageDesc);
    }

    @Override
    @Transactional
    public UserInfo getObjectById(String userCode) {
        return this.userInfoDao.getUserByCode(userCode);
    }

    @Override
    @Transactional
    public UserInfo getUserByRegEmail(String regEmail) {
        return this.userInfoDao.getUserByRegEmail(regEmail);
    }

    @Override
    @Transactional
    public UserInfo getUserByRegCellPhone(String regCellPhone) {
        return this.userInfoDao.getUserByRegCellPhone(regCellPhone);
    }

    @Override
    @Transactional
    public UserInfo getUserByUserWord(String userWord) {
        return this.userInfoDao.getUserByUserWord(userWord);
    }

    @Override
    public List<OptMethod> listUserPowers(String topUnit, String userCode) {
        List<FVUserOptList> fvUserOptLists = this.userInfoDao.listUserPowers(topUnit, userCode);
        ArrayList<OptMethod> optMethods = new ArrayList<OptMethod>();
        fvUserOptLists.forEach(fv -> {
            OptMethod method = new OptMethod();
            method.setOptId(fv.getOptId());
            method.setUserCode(fv.getUserCode());
            method.setOptCode(fv.getOptcode());
            method.setOptName(fv.getOptName());
            method.setOptMethod(fv.getOptMethod());
            optMethods.add(method);
        });
        return optMethods;
    }
}

